/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CopyCompletionError;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CreationData;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DataAccessAuthMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskSecurityProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Encryption;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.SupportedCapabilities;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SnapshotProperties
implements JsonSerializable<SnapshotProperties> {
    private OffsetDateTime timeCreated;
    private OperatingSystemTypes osType;
    private HyperVGeneration hyperVGeneration;
    private PurchasePlanAutoGenerated purchasePlan;
    private SupportedCapabilities supportedCapabilities;
    private CreationData creationData;
    private Integer diskSizeGB;
    private Long diskSizeBytes;
    private DiskState diskState;
    private String uniqueId;
    private EncryptionSettingsCollection encryptionSettingsCollection;
    private String provisioningState;
    private Boolean incremental;
    private String incrementalSnapshotFamilyId;
    private Encryption encryption;
    private NetworkAccessPolicy networkAccessPolicy;
    private String diskAccessId;
    private DiskSecurityProfile securityProfile;
    private Boolean supportsHibernation;
    private PublicNetworkAccess publicNetworkAccess;
    private Float completionPercent;
    private CopyCompletionError copyCompletionError;
    private DataAccessAuthMode dataAccessAuthMode;
    private static final ClientLogger LOGGER = new ClientLogger(SnapshotProperties.class);

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public SnapshotProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public SnapshotProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public PurchasePlanAutoGenerated purchasePlan() {
        return this.purchasePlan;
    }

    public SnapshotProperties withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public SupportedCapabilities supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public SnapshotProperties withSupportedCapabilities(SupportedCapabilities supportedCapabilities) {
        this.supportedCapabilities = supportedCapabilities;
        return this;
    }

    public CreationData creationData() {
        return this.creationData;
    }

    public SnapshotProperties withCreationData(CreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public SnapshotProperties withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public Long diskSizeBytes() {
        return this.diskSizeBytes;
    }

    public DiskState diskState() {
        return this.diskState;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.encryptionSettingsCollection;
    }

    public SnapshotProperties withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        this.encryptionSettingsCollection = encryptionSettingsCollection;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Boolean incremental() {
        return this.incremental;
    }

    public SnapshotProperties withIncremental(Boolean incremental) {
        this.incremental = incremental;
        return this;
    }

    public String incrementalSnapshotFamilyId() {
        return this.incrementalSnapshotFamilyId;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public SnapshotProperties withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    public SnapshotProperties withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    public String diskAccessId() {
        return this.diskAccessId;
    }

    public SnapshotProperties withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    public DiskSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public SnapshotProperties withSecurityProfile(DiskSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    public SnapshotProperties withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public SnapshotProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Float completionPercent() {
        return this.completionPercent;
    }

    public SnapshotProperties withCompletionPercent(Float completionPercent) {
        this.completionPercent = completionPercent;
        return this;
    }

    public CopyCompletionError copyCompletionError() {
        return this.copyCompletionError;
    }

    public SnapshotProperties withCopyCompletionError(CopyCompletionError copyCompletionError) {
        this.copyCompletionError = copyCompletionError;
        return this;
    }

    public DataAccessAuthMode dataAccessAuthMode() {
        return this.dataAccessAuthMode;
    }

    public SnapshotProperties withDataAccessAuthMode(DataAccessAuthMode dataAccessAuthMode) {
        this.dataAccessAuthMode = dataAccessAuthMode;
        return this;
    }

    public void validate() {
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.supportedCapabilities() != null) {
            this.supportedCapabilities().validate();
        }
        if (this.creationData() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property creationData in model SnapshotProperties"));
        }
        this.creationData().validate();
        if (this.encryptionSettingsCollection() != null) {
            this.encryptionSettingsCollection().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.copyCompletionError() != null) {
            this.copyCompletionError().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("creationData", this.creationData);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("hyperVGeneration", this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeJsonField("purchasePlan", this.purchasePlan);
        jsonWriter.writeJsonField("supportedCapabilities", this.supportedCapabilities);
        jsonWriter.writeNumberField("diskSizeGB", this.diskSizeGB);
        jsonWriter.writeJsonField("encryptionSettingsCollection", this.encryptionSettingsCollection);
        jsonWriter.writeBooleanField("incremental", this.incremental);
        jsonWriter.writeJsonField("encryption", this.encryption);
        jsonWriter.writeStringField("networkAccessPolicy", this.networkAccessPolicy == null ? null : this.networkAccessPolicy.toString());
        jsonWriter.writeStringField("diskAccessId", this.diskAccessId);
        jsonWriter.writeJsonField("securityProfile", this.securityProfile);
        jsonWriter.writeBooleanField("supportsHibernation", this.supportsHibernation);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeNumberField("completionPercent", this.completionPercent);
        jsonWriter.writeJsonField("copyCompletionError", this.copyCompletionError);
        jsonWriter.writeStringField("dataAccessAuthMode", this.dataAccessAuthMode == null ? null : this.dataAccessAuthMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static SnapshotProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SnapshotProperties deserializedSnapshotProperties = new SnapshotProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationData".equals(fieldName)) {
                    deserializedSnapshotProperties.creationData = CreationData.fromJson(reader);
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedSnapshotProperties.timeCreated = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedSnapshotProperties.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedSnapshotProperties.hyperVGeneration = HyperVGeneration.fromString(reader.getString());
                    continue;
                }
                if ("purchasePlan".equals(fieldName)) {
                    deserializedSnapshotProperties.purchasePlan = PurchasePlanAutoGenerated.fromJson(reader);
                    continue;
                }
                if ("supportedCapabilities".equals(fieldName)) {
                    deserializedSnapshotProperties.supportedCapabilities = SupportedCapabilities.fromJson(reader);
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedSnapshotProperties.diskSizeGB = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("diskSizeBytes".equals(fieldName)) {
                    deserializedSnapshotProperties.diskSizeBytes = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskState".equals(fieldName)) {
                    deserializedSnapshotProperties.diskState = DiskState.fromString(reader.getString());
                    continue;
                }
                if ("uniqueId".equals(fieldName)) {
                    deserializedSnapshotProperties.uniqueId = reader.getString();
                    continue;
                }
                if ("encryptionSettingsCollection".equals(fieldName)) {
                    deserializedSnapshotProperties.encryptionSettingsCollection = EncryptionSettingsCollection.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSnapshotProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("incremental".equals(fieldName)) {
                    deserializedSnapshotProperties.incremental = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("incrementalSnapshotFamilyId".equals(fieldName)) {
                    deserializedSnapshotProperties.incrementalSnapshotFamilyId = reader.getString();
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedSnapshotProperties.encryption = Encryption.fromJson(reader);
                    continue;
                }
                if ("networkAccessPolicy".equals(fieldName)) {
                    deserializedSnapshotProperties.networkAccessPolicy = NetworkAccessPolicy.fromString(reader.getString());
                    continue;
                }
                if ("diskAccessId".equals(fieldName)) {
                    deserializedSnapshotProperties.diskAccessId = reader.getString();
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedSnapshotProperties.securityProfile = DiskSecurityProfile.fromJson(reader);
                    continue;
                }
                if ("supportsHibernation".equals(fieldName)) {
                    deserializedSnapshotProperties.supportsHibernation = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedSnapshotProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("completionPercent".equals(fieldName)) {
                    deserializedSnapshotProperties.completionPercent = reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("copyCompletionError".equals(fieldName)) {
                    deserializedSnapshotProperties.copyCompletionError = CopyCompletionError.fromJson(reader);
                    continue;
                }
                if ("dataAccessAuthMode".equals(fieldName)) {
                    deserializedSnapshotProperties.dataAccessAuthMode = DataAccessAuthMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotProperties;
        });
    }
}

