/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.GalleriesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.GalleryInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.GalleryImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Galleries;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Gallery;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.BatchDeletionImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class GalleriesImpl
extends GroupableResourcesImpl<Gallery, GalleryImpl, GalleryInner, GalleriesClient, ComputeManager>
implements Galleries {
    public GalleriesImpl(ComputeManager manager) {
        super(((ComputeManagementClient)manager.serviceClient()).getGalleries(), manager);
    }

    @Override
    protected Mono<GalleryInner> getInnerAsync(String resourceGroupName, String name) {
        return ((GalleriesClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    @Override
    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((GalleriesClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    @Override
    public Flux<String> deleteByIdsAsync(Collection<String> ids) {
        return BatchDeletionImpl.deleteByIdsAsync(ids, this::deleteInnerAsync);
    }

    @Override
    public Flux<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    @Override
    public void deleteByIds(Collection<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.deleteByIdsAsync(ids).last().block();
        }
    }

    @Override
    public void deleteByIds(String ... ids) {
        this.deleteByIds(new ArrayList<String>(Arrays.asList(ids)));
    }

    @Override
    public PagedIterable<Gallery> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<Gallery>(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedFlux<Gallery> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return new PagedFlux<Gallery>(() -> Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return PagedConverter.mapPage(((GalleriesClient)this.inner()).listByResourceGroupAsync(resourceGroupName), this::wrapModel);
    }

    @Override
    public PagedIterable<Gallery> list() {
        return this.wrapList(((GalleriesClient)this.inner()).list());
    }

    @Override
    public PagedFlux<Gallery> listAsync() {
        return PagedConverter.mapPage(((GalleriesClient)this.inner()).listAsync(), this::wrapModel);
    }

    @Override
    public GalleryImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    protected GalleryImpl wrapModel(GalleryInner inner) {
        return new GalleryImpl(inner.name(), inner, (ComputeManager)this.manager());
    }

    @Override
    protected GalleryImpl wrapModel(String name) {
        return new GalleryImpl(name, new GalleryInner(), (ComputeManager)this.manager());
    }
}

