/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.EncryptionExtensionIdentifier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.LinuxEncryptionExtensionUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskVolumeEncryptionMonitor;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.EncryptionStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.InstanceViewTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineExtensionInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class LinuxDiskVolumeNoAADEncryptionMonitorImpl
implements DiskVolumeEncryptionMonitor {
    private final String rgName;
    private final String vmName;
    private final ComputeManager computeManager;
    private VirtualMachineInner virtualMachine;
    private VirtualMachineExtensionInstanceView extensionInstanceView;

    LinuxDiskVolumeNoAADEncryptionMonitorImpl(String virtualMachineId, ComputeManager computeManager) {
        this.rgName = ResourceUtils.groupFromResourceId(virtualMachineId);
        this.vmName = ResourceUtils.nameFromResourceId(virtualMachineId);
        this.computeManager = computeManager;
    }

    @Override
    public OperatingSystemTypes osType() {
        return OperatingSystemTypes.LINUX;
    }

    @Override
    public String progressMessage() {
        if (!this.hasEncryptionExtensionInstanceView()) {
            return null;
        }
        return LinuxEncryptionExtensionUtil.progressMessage(this.extensionInstanceView);
    }

    @Override
    public EncryptionStatus osDiskStatus() {
        if (!this.hasEncryptionExtensionInstanceView()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        return LinuxEncryptionExtensionUtil.osDiskStatus(this.extensionInstanceView);
    }

    @Override
    public EncryptionStatus dataDiskStatus() {
        if (!this.hasEncryptionExtensionInstanceView()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        return LinuxEncryptionExtensionUtil.dataDiskStatus(this.extensionInstanceView);
    }

    @Override
    public Map<String, InstanceViewStatus> diskInstanceViewEncryptionStatuses() {
        if (this.virtualMachine.instanceView() == null || this.virtualMachine.instanceView().disks() == null) {
            return new HashMap<String, InstanceViewStatus>();
        }
        HashMap<String, InstanceViewStatus> div = new HashMap<String, InstanceViewStatus>();
        block0: for (DiskInstanceView diskInstanceView : this.virtualMachine.instanceView().disks()) {
            for (InstanceViewStatus status : diskInstanceView.statuses()) {
                if (LinuxDiskVolumeNoAADEncryptionMonitorImpl.encryptionStatusFromCode(status.code()) == null) continue;
                div.put(diskInstanceView.name(), status);
                continue block0;
            }
        }
        return div;
    }

    @Override
    public DiskVolumeEncryptionMonitor refresh() {
        return this.refreshAsync().block();
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> refreshAsync() {
        LinuxDiskVolumeNoAADEncryptionMonitorImpl self = this;
        return this.retrieveVirtualMachineAsync().flatMap(virtualMachine -> {
            self.virtualMachine = virtualMachine;
            if (virtualMachine.instanceView() != null && virtualMachine.instanceView().extensions() != null) {
                for (VirtualMachineExtensionInstanceView eiv : virtualMachine.instanceView().extensions()) {
                    if (eiv.type() == null || !eiv.type().toLowerCase(Locale.ROOT).startsWith(EncryptionExtensionIdentifier.publisherName().toLowerCase(Locale.ROOT)) || eiv.name() == null || !EncryptionExtensionIdentifier.isEncryptionTypeName(eiv.name(), this.osType())) continue;
                    self.extensionInstanceView = eiv;
                    break;
                }
            }
            return Mono.just(self);
        });
    }

    private Mono<VirtualMachineInner> retrieveVirtualMachineAsync() {
        return ((ComputeManagementClient)this.computeManager.serviceClient()).getVirtualMachines().getByResourceGroupWithResponseAsync(this.rgName, this.vmName, InstanceViewTypes.INSTANCE_VIEW).map(Response::getValue);
    }

    private boolean hasEncryptionExtensionInstanceView() {
        return this.extensionInstanceView != null;
    }

    private static EncryptionStatus encryptionStatusFromCode(String code) {
        if (code != null && code.toLowerCase(Locale.ROOT).startsWith("encryptionstate")) {
            String[] parts = code.split("/", 2);
            if (parts.length != 2) {
                return EncryptionStatus.UNKNOWN;
            }
            return EncryptionStatus.fromString(parts[1]);
        }
        return null;
    }
}

