/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.CapacityReservationProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CapacityReservationInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.UpdateResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class CapacityReservationUpdate
extends UpdateResource {
    private CapacityReservationProperties innerProperties;
    private Sku sku;

    private CapacityReservationProperties innerProperties() {
        return this.innerProperties;
    }

    public Sku sku() {
        return this.sku;
    }

    public CapacityReservationUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    @Override
    public CapacityReservationUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String reservationId() {
        return this.innerProperties() == null ? null : this.innerProperties().reservationId();
    }

    public Integer platformFaultDomainCount() {
        return this.innerProperties() == null ? null : this.innerProperties().platformFaultDomainCount();
    }

    public List<SubResourceReadOnly> virtualMachinesAssociated() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachinesAssociated();
    }

    public OffsetDateTime provisioningTime() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningTime();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public CapacityReservationInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("sku", this.sku);
        return jsonWriter.writeEndObject();
    }

    public static CapacityReservationUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CapacityReservationUpdate deserializedCapacityReservationUpdate = new CapacityReservationUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCapacityReservationUpdate.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCapacityReservationUpdate.innerProperties = CapacityReservationProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedCapacityReservationUpdate.sku = Sku.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapacityReservationUpdate;
        });
    }
}

