/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.EncryptionSettingsElement;
import java.io.IOException;
import java.util.List;

public final class EncryptionSettingsCollection
implements JsonSerializable<EncryptionSettingsCollection> {
    private boolean enabled;
    private List<EncryptionSettingsElement> encryptionSettings;
    private String encryptionSettingsVersion;

    public boolean enabled() {
        return this.enabled;
    }

    public EncryptionSettingsCollection withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<EncryptionSettingsElement> encryptionSettings() {
        return this.encryptionSettings;
    }

    public EncryptionSettingsCollection withEncryptionSettings(List<EncryptionSettingsElement> encryptionSettings) {
        this.encryptionSettings = encryptionSettings;
        return this;
    }

    public String encryptionSettingsVersion() {
        return this.encryptionSettingsVersion;
    }

    public EncryptionSettingsCollection withEncryptionSettingsVersion(String encryptionSettingsVersion) {
        this.encryptionSettingsVersion = encryptionSettingsVersion;
        return this;
    }

    public void validate() {
        if (this.encryptionSettings() != null) {
            this.encryptionSettings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("encryptionSettings", this.encryptionSettings, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("encryptionSettingsVersion", this.encryptionSettingsVersion);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionSettingsCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionSettingsCollection deserializedEncryptionSettingsCollection = new EncryptionSettingsCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedEncryptionSettingsCollection.enabled = reader.getBoolean();
                    continue;
                }
                if ("encryptionSettings".equals(fieldName)) {
                    List<EncryptionSettingsElement> encryptionSettings = reader.readArray(reader1 -> EncryptionSettingsElement.fromJson(reader1));
                    deserializedEncryptionSettingsCollection.encryptionSettings = encryptionSettings;
                    continue;
                }
                if ("encryptionSettingsVersion".equals(fieldName)) {
                    deserializedEncryptionSettingsCollection.encryptionSettingsVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionSettingsCollection;
        });
    }
}

