/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.LinuxConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VaultSecretGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.WindowsConfiguration;
import java.io.IOException;
import java.util.List;

public final class OSProfile
implements JsonSerializable<OSProfile> {
    private String computerName;
    private String adminUsername;
    private String adminPassword;
    private String customData;
    private WindowsConfiguration windowsConfiguration;
    private LinuxConfiguration linuxConfiguration;
    private List<VaultSecretGroup> secrets;
    private Boolean allowExtensionOperations;
    private Boolean requireGuestProvisionSignal;

    public String computerName() {
        return this.computerName;
    }

    public OSProfile withComputerName(String computerName) {
        this.computerName = computerName;
        return this;
    }

    public String adminUsername() {
        return this.adminUsername;
    }

    public OSProfile withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return this;
    }

    public String adminPassword() {
        return this.adminPassword;
    }

    public OSProfile withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return this;
    }

    public String customData() {
        return this.customData;
    }

    public OSProfile withCustomData(String customData) {
        this.customData = customData;
        return this;
    }

    public WindowsConfiguration windowsConfiguration() {
        return this.windowsConfiguration;
    }

    public OSProfile withWindowsConfiguration(WindowsConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
        return this;
    }

    public LinuxConfiguration linuxConfiguration() {
        return this.linuxConfiguration;
    }

    public OSProfile withLinuxConfiguration(LinuxConfiguration linuxConfiguration) {
        this.linuxConfiguration = linuxConfiguration;
        return this;
    }

    public List<VaultSecretGroup> secrets() {
        return this.secrets;
    }

    public OSProfile withSecrets(List<VaultSecretGroup> secrets) {
        this.secrets = secrets;
        return this;
    }

    public Boolean allowExtensionOperations() {
        return this.allowExtensionOperations;
    }

    public OSProfile withAllowExtensionOperations(Boolean allowExtensionOperations) {
        this.allowExtensionOperations = allowExtensionOperations;
        return this;
    }

    public Boolean requireGuestProvisionSignal() {
        return this.requireGuestProvisionSignal;
    }

    public OSProfile withRequireGuestProvisionSignal(Boolean requireGuestProvisionSignal) {
        this.requireGuestProvisionSignal = requireGuestProvisionSignal;
        return this;
    }

    public void validate() {
        if (this.windowsConfiguration() != null) {
            this.windowsConfiguration().validate();
        }
        if (this.linuxConfiguration() != null) {
            this.linuxConfiguration().validate();
        }
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("computerName", this.computerName);
        jsonWriter.writeStringField("adminUsername", this.adminUsername);
        jsonWriter.writeStringField("adminPassword", this.adminPassword);
        jsonWriter.writeStringField("customData", this.customData);
        jsonWriter.writeJsonField("windowsConfiguration", this.windowsConfiguration);
        jsonWriter.writeJsonField("linuxConfiguration", this.linuxConfiguration);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("allowExtensionOperations", this.allowExtensionOperations);
        jsonWriter.writeBooleanField("requireGuestProvisionSignal", this.requireGuestProvisionSignal);
        return jsonWriter.writeEndObject();
    }

    public static OSProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OSProfile deserializedOSProfile = new OSProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("computerName".equals(fieldName)) {
                    deserializedOSProfile.computerName = reader.getString();
                    continue;
                }
                if ("adminUsername".equals(fieldName)) {
                    deserializedOSProfile.adminUsername = reader.getString();
                    continue;
                }
                if ("adminPassword".equals(fieldName)) {
                    deserializedOSProfile.adminPassword = reader.getString();
                    continue;
                }
                if ("customData".equals(fieldName)) {
                    deserializedOSProfile.customData = reader.getString();
                    continue;
                }
                if ("windowsConfiguration".equals(fieldName)) {
                    deserializedOSProfile.windowsConfiguration = WindowsConfiguration.fromJson(reader);
                    continue;
                }
                if ("linuxConfiguration".equals(fieldName)) {
                    deserializedOSProfile.linuxConfiguration = LinuxConfiguration.fromJson(reader);
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    List<VaultSecretGroup> secrets = reader.readArray(reader1 -> VaultSecretGroup.fromJson(reader1));
                    deserializedOSProfile.secrets = secrets;
                    continue;
                }
                if ("allowExtensionOperations".equals(fieldName)) {
                    deserializedOSProfile.allowExtensionOperations = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("requireGuestProvisionSignal".equals(fieldName)) {
                    deserializedOSProfile.requireGuestProvisionSignal = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOSProfile;
        });
    }
}

