/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.HardwareProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.OSProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.RestorePointSourceVMStorageProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.SecurityProfile;
import java.io.IOException;

public final class RestorePointSourceMetadata
implements JsonSerializable<RestorePointSourceMetadata> {
    private HardwareProfile hardwareProfile;
    private RestorePointSourceVMStorageProfile storageProfile;
    private OSProfile osProfile;
    private DiagnosticsProfile diagnosticsProfile;
    private String licenseType;
    private String vmId;
    private SecurityProfile securityProfile;
    private String location;
    private String userData;
    private HyperVGenerationTypes hyperVGeneration;

    public HardwareProfile hardwareProfile() {
        return this.hardwareProfile;
    }

    public RestorePointSourceVMStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public RestorePointSourceMetadata withStorageProfile(RestorePointSourceVMStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public OSProfile osProfile() {
        return this.osProfile;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.diagnosticsProfile;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public String vmId() {
        return this.vmId;
    }

    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public String location() {
        return this.location;
    }

    public String userData() {
        return this.userData;
    }

    public HyperVGenerationTypes hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public void validate() {
        if (this.hardwareProfile() != null) {
            this.hardwareProfile().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
        if (this.diagnosticsProfile() != null) {
            this.diagnosticsProfile().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("storageProfile", this.storageProfile);
        return jsonWriter.writeEndObject();
    }

    public static RestorePointSourceMetadata fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorePointSourceMetadata deserializedRestorePointSourceMetadata = new RestorePointSourceMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hardwareProfile".equals(fieldName)) {
                    deserializedRestorePointSourceMetadata.hardwareProfile = HardwareProfile.fromJson(reader);
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedRestorePointSourceMetadata.storageProfile = RestorePointSourceVMStorageProfile.fromJson(reader);
                    continue;
                }
                if ("osProfile".equals(fieldName)) {
                    deserializedRestorePointSourceMetadata.osProfile = OSProfile.fromJson(reader);
                    continue;
                }
                if ("diagnosticsProfile".equals(fieldName)) {
                    deserializedRestorePointSourceMetadata.diagnosticsProfile = DiagnosticsProfile.fromJson(reader);
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedRestorePointSourceMetadata.licenseType = reader.getString();
                    continue;
                }
                if ("vmId".equals(fieldName)) {
                    deserializedRestorePointSourceMetadata.vmId = reader.getString();
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedRestorePointSourceMetadata.securityProfile = SecurityProfile.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRestorePointSourceMetadata.location = reader.getString();
                    continue;
                }
                if ("userData".equals(fieldName)) {
                    deserializedRestorePointSourceMetadata.userData = reader.getString();
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedRestorePointSourceMetadata.hyperVGeneration = HyperVGenerationTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorePointSourceMetadata;
        });
    }
}

