/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.LinuxConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VaultSecretGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.WindowsConfiguration;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetUpdateOSProfile
implements JsonSerializable<VirtualMachineScaleSetUpdateOSProfile> {
    private String customData;
    private WindowsConfiguration windowsConfiguration;
    private LinuxConfiguration linuxConfiguration;
    private List<VaultSecretGroup> secrets;

    public String customData() {
        return this.customData;
    }

    public VirtualMachineScaleSetUpdateOSProfile withCustomData(String customData) {
        this.customData = customData;
        return this;
    }

    public WindowsConfiguration windowsConfiguration() {
        return this.windowsConfiguration;
    }

    public VirtualMachineScaleSetUpdateOSProfile withWindowsConfiguration(WindowsConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
        return this;
    }

    public LinuxConfiguration linuxConfiguration() {
        return this.linuxConfiguration;
    }

    public VirtualMachineScaleSetUpdateOSProfile withLinuxConfiguration(LinuxConfiguration linuxConfiguration) {
        this.linuxConfiguration = linuxConfiguration;
        return this;
    }

    public List<VaultSecretGroup> secrets() {
        return this.secrets;
    }

    public VirtualMachineScaleSetUpdateOSProfile withSecrets(List<VaultSecretGroup> secrets) {
        this.secrets = secrets;
        return this;
    }

    public void validate() {
        if (this.windowsConfiguration() != null) {
            this.windowsConfiguration().validate();
        }
        if (this.linuxConfiguration() != null) {
            this.linuxConfiguration().validate();
        }
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("customData", this.customData);
        jsonWriter.writeJsonField("windowsConfiguration", this.windowsConfiguration);
        jsonWriter.writeJsonField("linuxConfiguration", this.linuxConfiguration);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetUpdateOSProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetUpdateOSProfile deserializedVirtualMachineScaleSetUpdateOSProfile = new VirtualMachineScaleSetUpdateOSProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("customData".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSProfile.customData = reader.getString();
                    continue;
                }
                if ("windowsConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSProfile.windowsConfiguration = WindowsConfiguration.fromJson(reader);
                    continue;
                }
                if ("linuxConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSProfile.linuxConfiguration = LinuxConfiguration.fromJson(reader);
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    List<VaultSecretGroup> secrets = reader.readArray(reader1 -> VaultSecretGroup.fromJson(reader1));
                    deserializedVirtualMachineScaleSetUpdateOSProfile.secrets = secrets;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetUpdateOSProfile;
        });
    }
}

