/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VMGuestPatchClassificationWindows;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class WindowsParameters
implements JsonSerializable<WindowsParameters> {
    private List<VMGuestPatchClassificationWindows> classificationsToInclude;
    private List<String> kbNumbersToInclude;
    private List<String> kbNumbersToExclude;
    private Boolean excludeKbsRequiringReboot;
    private OffsetDateTime maxPatchPublishDate;

    public List<VMGuestPatchClassificationWindows> classificationsToInclude() {
        return this.classificationsToInclude;
    }

    public WindowsParameters withClassificationsToInclude(List<VMGuestPatchClassificationWindows> classificationsToInclude) {
        this.classificationsToInclude = classificationsToInclude;
        return this;
    }

    public List<String> kbNumbersToInclude() {
        return this.kbNumbersToInclude;
    }

    public WindowsParameters withKbNumbersToInclude(List<String> kbNumbersToInclude) {
        this.kbNumbersToInclude = kbNumbersToInclude;
        return this;
    }

    public List<String> kbNumbersToExclude() {
        return this.kbNumbersToExclude;
    }

    public WindowsParameters withKbNumbersToExclude(List<String> kbNumbersToExclude) {
        this.kbNumbersToExclude = kbNumbersToExclude;
        return this;
    }

    public Boolean excludeKbsRequiringReboot() {
        return this.excludeKbsRequiringReboot;
    }

    public WindowsParameters withExcludeKbsRequiringReboot(Boolean excludeKbsRequiringReboot) {
        this.excludeKbsRequiringReboot = excludeKbsRequiringReboot;
        return this;
    }

    public OffsetDateTime maxPatchPublishDate() {
        return this.maxPatchPublishDate;
    }

    public WindowsParameters withMaxPatchPublishDate(OffsetDateTime maxPatchPublishDate) {
        this.maxPatchPublishDate = maxPatchPublishDate;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("classificationsToInclude", this.classificationsToInclude, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("kbNumbersToInclude", this.kbNumbersToInclude, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("kbNumbersToExclude", this.kbNumbersToExclude, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("excludeKbsRequiringReboot", this.excludeKbsRequiringReboot);
        jsonWriter.writeStringField("maxPatchPublishDate", this.maxPatchPublishDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.maxPatchPublishDate));
        return jsonWriter.writeEndObject();
    }

    public static WindowsParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WindowsParameters deserializedWindowsParameters = new WindowsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("classificationsToInclude".equals(fieldName)) {
                    List<VMGuestPatchClassificationWindows> classificationsToInclude = reader.readArray(reader1 -> VMGuestPatchClassificationWindows.fromString(reader1.getString()));
                    deserializedWindowsParameters.classificationsToInclude = classificationsToInclude;
                    continue;
                }
                if ("kbNumbersToInclude".equals(fieldName)) {
                    List<String> kbNumbersToInclude = reader.readArray(reader1 -> reader1.getString());
                    deserializedWindowsParameters.kbNumbersToInclude = kbNumbersToInclude;
                    continue;
                }
                if ("kbNumbersToExclude".equals(fieldName)) {
                    List<String> kbNumbersToExclude = reader.readArray(reader1 -> reader1.getString());
                    deserializedWindowsParameters.kbNumbersToExclude = kbNumbersToExclude;
                    continue;
                }
                if ("excludeKbsRequiringReboot".equals(fieldName)) {
                    deserializedWindowsParameters.excludeKbsRequiringReboot = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxPatchPublishDate".equals(fieldName)) {
                    deserializedWindowsParameters.maxPatchPublishDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWindowsParameters;
        });
    }
}

