/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerPort;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerProbe;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerPropertiesInstanceView;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.EnvironmentVariable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ResourceRequirements;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.SecurityContextDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.VolumeMount;
import java.io.IOException;
import java.util.List;

public final class ContainerProperties
implements JsonSerializable<ContainerProperties> {
    private String image;
    private List<String> command;
    private List<ContainerPort> ports;
    private List<EnvironmentVariable> environmentVariables;
    private ContainerPropertiesInstanceView instanceView;
    private ResourceRequirements resources;
    private List<VolumeMount> volumeMounts;
    private ContainerProbe livenessProbe;
    private ContainerProbe readinessProbe;
    private SecurityContextDefinition securityContext;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerProperties.class);

    public String image() {
        return this.image;
    }

    public ContainerProperties withImage(String image) {
        this.image = image;
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public ContainerProperties withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public List<ContainerPort> ports() {
        return this.ports;
    }

    public ContainerProperties withPorts(List<ContainerPort> ports) {
        this.ports = ports;
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public ContainerProperties withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public ContainerPropertiesInstanceView instanceView() {
        return this.instanceView;
    }

    public ResourceRequirements resources() {
        return this.resources;
    }

    public ContainerProperties withResources(ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public ContainerProperties withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public ContainerProbe livenessProbe() {
        return this.livenessProbe;
    }

    public ContainerProperties withLivenessProbe(ContainerProbe livenessProbe) {
        this.livenessProbe = livenessProbe;
        return this;
    }

    public ContainerProbe readinessProbe() {
        return this.readinessProbe;
    }

    public ContainerProperties withReadinessProbe(ContainerProbe readinessProbe) {
        this.readinessProbe = readinessProbe;
        return this;
    }

    public SecurityContextDefinition securityContext() {
        return this.securityContext;
    }

    public ContainerProperties withSecurityContext(SecurityContextDefinition securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    public void validate() {
        if (this.image() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property image in model ContainerProperties"));
        }
        if (this.ports() != null) {
            this.ports().forEach(e -> e.validate());
        }
        if (this.environmentVariables() != null) {
            this.environmentVariables().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.resources() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property resources in model ContainerProperties"));
        }
        this.resources().validate();
        if (this.volumeMounts() != null) {
            this.volumeMounts().forEach(e -> e.validate());
        }
        if (this.livenessProbe() != null) {
            this.livenessProbe().validate();
        }
        if (this.readinessProbe() != null) {
            this.readinessProbe().validate();
        }
        if (this.securityContext() != null) {
            this.securityContext().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("image", this.image);
        jsonWriter.writeJsonField("resources", this.resources);
        jsonWriter.writeArrayField("command", this.command, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("ports", this.ports, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("environmentVariables", this.environmentVariables, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("volumeMounts", this.volumeMounts, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("livenessProbe", this.livenessProbe);
        jsonWriter.writeJsonField("readinessProbe", this.readinessProbe);
        jsonWriter.writeJsonField("securityContext", this.securityContext);
        return jsonWriter.writeEndObject();
    }

    public static ContainerProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerProperties deserializedContainerProperties = new ContainerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image".equals(fieldName)) {
                    deserializedContainerProperties.image = reader.getString();
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    deserializedContainerProperties.resources = ResourceRequirements.fromJson(reader);
                    continue;
                }
                if ("command".equals(fieldName)) {
                    List<String> command = reader.readArray(reader1 -> reader1.getString());
                    deserializedContainerProperties.command = command;
                    continue;
                }
                if ("ports".equals(fieldName)) {
                    List<ContainerPort> ports = reader.readArray(reader1 -> ContainerPort.fromJson(reader1));
                    deserializedContainerProperties.ports = ports;
                    continue;
                }
                if ("environmentVariables".equals(fieldName)) {
                    List<EnvironmentVariable> environmentVariables = reader.readArray(reader1 -> EnvironmentVariable.fromJson(reader1));
                    deserializedContainerProperties.environmentVariables = environmentVariables;
                    continue;
                }
                if ("instanceView".equals(fieldName)) {
                    deserializedContainerProperties.instanceView = ContainerPropertiesInstanceView.fromJson(reader);
                    continue;
                }
                if ("volumeMounts".equals(fieldName)) {
                    List<VolumeMount> volumeMounts = reader.readArray(reader1 -> VolumeMount.fromJson(reader1));
                    deserializedContainerProperties.volumeMounts = volumeMounts;
                    continue;
                }
                if ("livenessProbe".equals(fieldName)) {
                    deserializedContainerProperties.livenessProbe = ContainerProbe.fromJson(reader);
                    continue;
                }
                if ("readinessProbe".equals(fieldName)) {
                    deserializedContainerProperties.readinessProbe = ContainerProbe.fromJson(reader);
                    continue;
                }
                if ("securityContext".equals(fieldName)) {
                    deserializedContainerProperties.securityContext = SecurityContextDefinition.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerProperties;
        });
    }
}

