/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroupIdentityUserAssignedIdentities;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ResourceIdentityType;
import java.io.IOException;
import java.util.Map;

public final class ContainerGroupIdentity
implements JsonSerializable<ContainerGroupIdentity> {
    private String principalId;
    private String tenantId;
    private ResourceIdentityType type;
    private Map<String, ContainerGroupIdentityUserAssignedIdentities> userAssignedIdentities;

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ResourceIdentityType type() {
        return this.type;
    }

    public ContainerGroupIdentity withType(ResourceIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, ContainerGroupIdentityUserAssignedIdentities> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public ContainerGroupIdentity withUserAssignedIdentities(Map<String, ContainerGroupIdentityUserAssignedIdentities> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ContainerGroupIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerGroupIdentity deserializedContainerGroupIdentity = new ContainerGroupIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedContainerGroupIdentity.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedContainerGroupIdentity.tenantId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContainerGroupIdentity.type = ResourceIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map<String, ContainerGroupIdentityUserAssignedIdentities> userAssignedIdentities = reader.readMap(reader1 -> ContainerGroupIdentityUserAssignedIdentities.fromJson(reader1));
                    deserializedContainerGroupIdentity.userAssignedIdentities = userAssignedIdentities;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerGroupIdentity;
        });
    }
}

