/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.AuthCredential;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class CredentialSetProperties
implements JsonSerializable<CredentialSetProperties> {
    private String loginServer;
    private List<AuthCredential> authCredentials;
    private OffsetDateTime creationDate;
    private ProvisioningState provisioningState;

    public String loginServer() {
        return this.loginServer;
    }

    public CredentialSetProperties withLoginServer(String loginServer) {
        this.loginServer = loginServer;
        return this;
    }

    public List<AuthCredential> authCredentials() {
        return this.authCredentials;
    }

    public CredentialSetProperties withAuthCredentials(List<AuthCredential> authCredentials) {
        this.authCredentials = authCredentials;
        return this;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.authCredentials() != null) {
            this.authCredentials().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("loginServer", this.loginServer);
        jsonWriter.writeArrayField("authCredentials", this.authCredentials, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static CredentialSetProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CredentialSetProperties deserializedCredentialSetProperties = new CredentialSetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loginServer".equals(fieldName)) {
                    deserializedCredentialSetProperties.loginServer = reader.getString();
                    continue;
                }
                if ("authCredentials".equals(fieldName)) {
                    List<AuthCredential> authCredentials = reader.readArray(reader1 -> AuthCredential.fromJson(reader1));
                    deserializedCredentialSetProperties.authCredentials = authCredentials;
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedCredentialSetProperties.creationDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCredentialSetProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentialSetProperties;
        });
    }
}

