/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.fluent.models.PrivateEndpointConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.EncryptionProperty;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.NetworkRuleBypassOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Policies;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Status;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.ZoneRedundancy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class RegistryProperties
implements JsonSerializable<RegistryProperties> {
    private String loginServer;
    private OffsetDateTime creationDate;
    private ProvisioningState provisioningState;
    private Status status;
    private Boolean adminUserEnabled;
    private NetworkRuleSet networkRuleSet;
    private Policies policies;
    private EncryptionProperty encryption;
    private Boolean dataEndpointEnabled;
    private List<String> dataEndpointHostNames;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private PublicNetworkAccess publicNetworkAccess;
    private NetworkRuleBypassOptions networkRuleBypassOptions;
    private ZoneRedundancy zoneRedundancy;

    public String loginServer() {
        return this.loginServer;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Status status() {
        return this.status;
    }

    public Boolean adminUserEnabled() {
        return this.adminUserEnabled;
    }

    public RegistryProperties withAdminUserEnabled(Boolean adminUserEnabled) {
        this.adminUserEnabled = adminUserEnabled;
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public RegistryProperties withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    public Policies policies() {
        return this.policies;
    }

    public RegistryProperties withPolicies(Policies policies) {
        this.policies = policies;
        return this;
    }

    public EncryptionProperty encryption() {
        return this.encryption;
    }

    public RegistryProperties withEncryption(EncryptionProperty encryption) {
        this.encryption = encryption;
        return this;
    }

    public Boolean dataEndpointEnabled() {
        return this.dataEndpointEnabled;
    }

    public RegistryProperties withDataEndpointEnabled(Boolean dataEndpointEnabled) {
        this.dataEndpointEnabled = dataEndpointEnabled;
        return this;
    }

    public List<String> dataEndpointHostNames() {
        return this.dataEndpointHostNames;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public RegistryProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public NetworkRuleBypassOptions networkRuleBypassOptions() {
        return this.networkRuleBypassOptions;
    }

    public RegistryProperties withNetworkRuleBypassOptions(NetworkRuleBypassOptions networkRuleBypassOptions) {
        this.networkRuleBypassOptions = networkRuleBypassOptions;
        return this;
    }

    public ZoneRedundancy zoneRedundancy() {
        return this.zoneRedundancy;
    }

    public RegistryProperties withZoneRedundancy(ZoneRedundancy zoneRedundancy) {
        this.zoneRedundancy = zoneRedundancy;
        return this;
    }

    public void validate() {
        if (this.status() != null) {
            this.status().validate();
        }
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.policies() != null) {
            this.policies().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("adminUserEnabled", this.adminUserEnabled);
        jsonWriter.writeJsonField("networkRuleSet", this.networkRuleSet);
        jsonWriter.writeJsonField("policies", this.policies);
        jsonWriter.writeJsonField("encryption", this.encryption);
        jsonWriter.writeBooleanField("dataEndpointEnabled", this.dataEndpointEnabled);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("networkRuleBypassOptions", this.networkRuleBypassOptions == null ? null : this.networkRuleBypassOptions.toString());
        jsonWriter.writeStringField("zoneRedundancy", this.zoneRedundancy == null ? null : this.zoneRedundancy.toString());
        return jsonWriter.writeEndObject();
    }

    public static RegistryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RegistryProperties deserializedRegistryProperties = new RegistryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loginServer".equals(fieldName)) {
                    deserializedRegistryProperties.loginServer = reader.getString();
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedRegistryProperties.creationDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRegistryProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedRegistryProperties.status = Status.fromJson(reader);
                    continue;
                }
                if ("adminUserEnabled".equals(fieldName)) {
                    deserializedRegistryProperties.adminUserEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("networkRuleSet".equals(fieldName)) {
                    deserializedRegistryProperties.networkRuleSet = NetworkRuleSet.fromJson(reader);
                    continue;
                }
                if ("policies".equals(fieldName)) {
                    deserializedRegistryProperties.policies = Policies.fromJson(reader);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedRegistryProperties.encryption = EncryptionProperty.fromJson(reader);
                    continue;
                }
                if ("dataEndpointEnabled".equals(fieldName)) {
                    deserializedRegistryProperties.dataEndpointEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("dataEndpointHostNames".equals(fieldName)) {
                    List<String> dataEndpointHostNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedRegistryProperties.dataEndpointHostNames = dataEndpointHostNames;
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List<PrivateEndpointConnectionInner> privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    deserializedRegistryProperties.privateEndpointConnections = privateEndpointConnections;
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedRegistryProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("networkRuleBypassOptions".equals(fieldName)) {
                    deserializedRegistryProperties.networkRuleBypassOptions = NetworkRuleBypassOptions.fromString(reader.getString());
                    continue;
                }
                if ("zoneRedundancy".equals(fieldName)) {
                    deserializedRegistryProperties.zoneRedundancy = ZoneRedundancy.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRegistryProperties;
        });
    }
}

