/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.ImageDescriptor;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ImageUpdateTrigger
implements JsonSerializable<ImageUpdateTrigger> {
    private String id;
    private OffsetDateTime timestamp;
    private List<ImageDescriptor> images;

    public String id() {
        return this.id;
    }

    public ImageUpdateTrigger withId(String id) {
        this.id = id;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public ImageUpdateTrigger withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public List<ImageDescriptor> images() {
        return this.images;
    }

    public ImageUpdateTrigger withImages(List<ImageDescriptor> images) {
        this.images = images;
        return this;
    }

    public void validate() {
        if (this.images() != null) {
            this.images().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeArrayField("images", this.images, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ImageUpdateTrigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImageUpdateTrigger deserializedImageUpdateTrigger = new ImageUpdateTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedImageUpdateTrigger.id = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedImageUpdateTrigger.timestamp = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("images".equals(fieldName)) {
                    List<ImageDescriptor> images = reader.readArray(reader1 -> ImageDescriptor.fromJson(reader1));
                    deserializedImageUpdateTrigger.images = images;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageUpdateTrigger;
        });
    }
}

