/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.SourceTriggerEvent;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.SourceUpdateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.TriggerStatus;
import java.io.IOException;
import java.util.List;

public final class SourceTriggerUpdateParameters
implements JsonSerializable<SourceTriggerUpdateParameters> {
    private SourceUpdateParameters sourceRepository;
    private List<SourceTriggerEvent> sourceTriggerEvents;
    private TriggerStatus status;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(SourceTriggerUpdateParameters.class);

    public SourceUpdateParameters sourceRepository() {
        return this.sourceRepository;
    }

    public SourceTriggerUpdateParameters withSourceRepository(SourceUpdateParameters sourceRepository) {
        this.sourceRepository = sourceRepository;
        return this;
    }

    public List<SourceTriggerEvent> sourceTriggerEvents() {
        return this.sourceTriggerEvents;
    }

    public SourceTriggerUpdateParameters withSourceTriggerEvents(List<SourceTriggerEvent> sourceTriggerEvents) {
        this.sourceTriggerEvents = sourceTriggerEvents;
        return this;
    }

    public TriggerStatus status() {
        return this.status;
    }

    public SourceTriggerUpdateParameters withStatus(TriggerStatus status) {
        this.status = status;
        return this;
    }

    public String name() {
        return this.name;
    }

    public SourceTriggerUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.sourceRepository() != null) {
            this.sourceRepository().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model SourceTriggerUpdateParameters"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("sourceRepository", this.sourceRepository);
        jsonWriter.writeArrayField("sourceTriggerEvents", this.sourceTriggerEvents, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static SourceTriggerUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SourceTriggerUpdateParameters deserializedSourceTriggerUpdateParameters = new SourceTriggerUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSourceTriggerUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("sourceRepository".equals(fieldName)) {
                    deserializedSourceTriggerUpdateParameters.sourceRepository = SourceUpdateParameters.fromJson(reader);
                    continue;
                }
                if ("sourceTriggerEvents".equals(fieldName)) {
                    List<SourceTriggerEvent> sourceTriggerEvents = reader.readArray(reader1 -> SourceTriggerEvent.fromString(reader1.getString()));
                    deserializedSourceTriggerUpdateParameters.sourceTriggerEvents = sourceTriggerEvents;
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSourceTriggerUpdateParameters.status = TriggerStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceTriggerUpdateParameters;
        });
    }
}

