/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.AdvancedNetworking;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.IpFamily;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.LoadBalancerSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.ManagedClusterLoadBalancerProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.ManagedClusterNatGatewayProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.NetworkDataplane;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.NetworkMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.NetworkPlugin;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.NetworkPluginMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.NetworkPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OutboundType;
import java.io.IOException;
import java.util.List;

public final class ContainerServiceNetworkProfile
implements JsonSerializable<ContainerServiceNetworkProfile> {
    private NetworkPlugin networkPlugin;
    private NetworkPluginMode networkPluginMode;
    private NetworkPolicy networkPolicy;
    private NetworkMode networkMode;
    private NetworkDataplane networkDataplane;
    private AdvancedNetworking advancedNetworking;
    private String podCidr;
    private String serviceCidr;
    private String dnsServiceIp;
    private OutboundType outboundType;
    private LoadBalancerSku loadBalancerSku;
    private ManagedClusterLoadBalancerProfile loadBalancerProfile;
    private ManagedClusterNatGatewayProfile natGatewayProfile;
    private List<String> podCidrs;
    private List<String> serviceCidrs;
    private List<IpFamily> ipFamilies;

    public NetworkPlugin networkPlugin() {
        return this.networkPlugin;
    }

    public ContainerServiceNetworkProfile withNetworkPlugin(NetworkPlugin networkPlugin) {
        this.networkPlugin = networkPlugin;
        return this;
    }

    public NetworkPluginMode networkPluginMode() {
        return this.networkPluginMode;
    }

    public ContainerServiceNetworkProfile withNetworkPluginMode(NetworkPluginMode networkPluginMode) {
        this.networkPluginMode = networkPluginMode;
        return this;
    }

    public NetworkPolicy networkPolicy() {
        return this.networkPolicy;
    }

    public ContainerServiceNetworkProfile withNetworkPolicy(NetworkPolicy networkPolicy) {
        this.networkPolicy = networkPolicy;
        return this;
    }

    public NetworkMode networkMode() {
        return this.networkMode;
    }

    public ContainerServiceNetworkProfile withNetworkMode(NetworkMode networkMode) {
        this.networkMode = networkMode;
        return this;
    }

    public NetworkDataplane networkDataplane() {
        return this.networkDataplane;
    }

    public ContainerServiceNetworkProfile withNetworkDataplane(NetworkDataplane networkDataplane) {
        this.networkDataplane = networkDataplane;
        return this;
    }

    public AdvancedNetworking advancedNetworking() {
        return this.advancedNetworking;
    }

    public ContainerServiceNetworkProfile withAdvancedNetworking(AdvancedNetworking advancedNetworking) {
        this.advancedNetworking = advancedNetworking;
        return this;
    }

    public String podCidr() {
        return this.podCidr;
    }

    public ContainerServiceNetworkProfile withPodCidr(String podCidr) {
        this.podCidr = podCidr;
        return this;
    }

    public String serviceCidr() {
        return this.serviceCidr;
    }

    public ContainerServiceNetworkProfile withServiceCidr(String serviceCidr) {
        this.serviceCidr = serviceCidr;
        return this;
    }

    public String dnsServiceIp() {
        return this.dnsServiceIp;
    }

    public ContainerServiceNetworkProfile withDnsServiceIp(String dnsServiceIp) {
        this.dnsServiceIp = dnsServiceIp;
        return this;
    }

    public OutboundType outboundType() {
        return this.outboundType;
    }

    public ContainerServiceNetworkProfile withOutboundType(OutboundType outboundType) {
        this.outboundType = outboundType;
        return this;
    }

    public LoadBalancerSku loadBalancerSku() {
        return this.loadBalancerSku;
    }

    public ContainerServiceNetworkProfile withLoadBalancerSku(LoadBalancerSku loadBalancerSku) {
        this.loadBalancerSku = loadBalancerSku;
        return this;
    }

    public ManagedClusterLoadBalancerProfile loadBalancerProfile() {
        return this.loadBalancerProfile;
    }

    public ContainerServiceNetworkProfile withLoadBalancerProfile(ManagedClusterLoadBalancerProfile loadBalancerProfile) {
        this.loadBalancerProfile = loadBalancerProfile;
        return this;
    }

    public ManagedClusterNatGatewayProfile natGatewayProfile() {
        return this.natGatewayProfile;
    }

    public ContainerServiceNetworkProfile withNatGatewayProfile(ManagedClusterNatGatewayProfile natGatewayProfile) {
        this.natGatewayProfile = natGatewayProfile;
        return this;
    }

    public List<String> podCidrs() {
        return this.podCidrs;
    }

    public ContainerServiceNetworkProfile withPodCidrs(List<String> podCidrs) {
        this.podCidrs = podCidrs;
        return this;
    }

    public List<String> serviceCidrs() {
        return this.serviceCidrs;
    }

    public ContainerServiceNetworkProfile withServiceCidrs(List<String> serviceCidrs) {
        this.serviceCidrs = serviceCidrs;
        return this;
    }

    public List<IpFamily> ipFamilies() {
        return this.ipFamilies;
    }

    public ContainerServiceNetworkProfile withIpFamilies(List<IpFamily> ipFamilies) {
        this.ipFamilies = ipFamilies;
        return this;
    }

    public void validate() {
        if (this.advancedNetworking() != null) {
            this.advancedNetworking().validate();
        }
        if (this.loadBalancerProfile() != null) {
            this.loadBalancerProfile().validate();
        }
        if (this.natGatewayProfile() != null) {
            this.natGatewayProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkPlugin", this.networkPlugin == null ? null : this.networkPlugin.toString());
        jsonWriter.writeStringField("networkPluginMode", this.networkPluginMode == null ? null : this.networkPluginMode.toString());
        jsonWriter.writeStringField("networkPolicy", this.networkPolicy == null ? null : this.networkPolicy.toString());
        jsonWriter.writeStringField("networkMode", this.networkMode == null ? null : this.networkMode.toString());
        jsonWriter.writeStringField("networkDataplane", this.networkDataplane == null ? null : this.networkDataplane.toString());
        jsonWriter.writeJsonField("advancedNetworking", this.advancedNetworking);
        jsonWriter.writeStringField("podCidr", this.podCidr);
        jsonWriter.writeStringField("serviceCidr", this.serviceCidr);
        jsonWriter.writeStringField("dnsServiceIP", this.dnsServiceIp);
        jsonWriter.writeStringField("outboundType", this.outboundType == null ? null : this.outboundType.toString());
        jsonWriter.writeStringField("loadBalancerSku", this.loadBalancerSku == null ? null : this.loadBalancerSku.toString());
        jsonWriter.writeJsonField("loadBalancerProfile", this.loadBalancerProfile);
        jsonWriter.writeJsonField("natGatewayProfile", this.natGatewayProfile);
        jsonWriter.writeArrayField("podCidrs", this.podCidrs, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("serviceCidrs", this.serviceCidrs, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("ipFamilies", this.ipFamilies, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static ContainerServiceNetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerServiceNetworkProfile deserializedContainerServiceNetworkProfile = new ContainerServiceNetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkPlugin".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.networkPlugin = NetworkPlugin.fromString(reader.getString());
                    continue;
                }
                if ("networkPluginMode".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.networkPluginMode = NetworkPluginMode.fromString(reader.getString());
                    continue;
                }
                if ("networkPolicy".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.networkPolicy = NetworkPolicy.fromString(reader.getString());
                    continue;
                }
                if ("networkMode".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.networkMode = NetworkMode.fromString(reader.getString());
                    continue;
                }
                if ("networkDataplane".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.networkDataplane = NetworkDataplane.fromString(reader.getString());
                    continue;
                }
                if ("advancedNetworking".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.advancedNetworking = AdvancedNetworking.fromJson(reader);
                    continue;
                }
                if ("podCidr".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.podCidr = reader.getString();
                    continue;
                }
                if ("serviceCidr".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.serviceCidr = reader.getString();
                    continue;
                }
                if ("dnsServiceIP".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.dnsServiceIp = reader.getString();
                    continue;
                }
                if ("outboundType".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.outboundType = OutboundType.fromString(reader.getString());
                    continue;
                }
                if ("loadBalancerSku".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.loadBalancerSku = LoadBalancerSku.fromString(reader.getString());
                    continue;
                }
                if ("loadBalancerProfile".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.loadBalancerProfile = ManagedClusterLoadBalancerProfile.fromJson(reader);
                    continue;
                }
                if ("natGatewayProfile".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.natGatewayProfile = ManagedClusterNatGatewayProfile.fromJson(reader);
                    continue;
                }
                if ("podCidrs".equals(fieldName)) {
                    List<String> podCidrs = reader.readArray(reader1 -> reader1.getString());
                    deserializedContainerServiceNetworkProfile.podCidrs = podCidrs;
                    continue;
                }
                if ("serviceCidrs".equals(fieldName)) {
                    List<String> serviceCidrs = reader.readArray(reader1 -> reader1.getString());
                    deserializedContainerServiceNetworkProfile.serviceCidrs = serviceCidrs;
                    continue;
                }
                if ("ipFamilies".equals(fieldName)) {
                    List<IpFamily> ipFamilies = reader.readArray(reader1 -> IpFamily.fromString(reader1.getString()));
                    deserializedContainerServiceNetworkProfile.ipFamilies = ipFamilies;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerServiceNetworkProfile;
        });
    }
}

