/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.CollectionPartitionsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.PartitionMetricInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.PartitionUsageInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.PartitionMetricListResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.PartitionUsagesResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class CollectionPartitionsClientImpl
implements CollectionPartitionsClient {
    private final CollectionPartitionsService service;
    private final CosmosDBManagementClientImpl client;

    CollectionPartitionsClientImpl(CosmosDBManagementClientImpl client) {
        this.service = RestProxy.create(CollectionPartitionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PartitionMetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.getApiVersion(), filter, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PartitionMetricInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PartitionMetricListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PartitionMetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.getApiVersion(), filter, "application/json", context).map(res -> new PagedResponseBase<Object, PartitionMetricInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PartitionMetricListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PartitionMetricInner> listMetricsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        return new PagedFlux<PartitionMetricInner>(() -> this.listMetricsSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PartitionMetricInner> listMetricsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, Context context) {
        return new PagedFlux<PartitionMetricInner>(() -> this.listMetricsSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PartitionMetricInner> listMetrics(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        return new PagedIterable<PartitionMetricInner>(this.listMetricsAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PartitionMetricInner> listMetrics(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, Context context) {
        return new PagedIterable<PartitionMetricInner>(this.listMetricsAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PartitionUsageInner>> listUsagesSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listUsages(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.getApiVersion(), filter, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PartitionUsageInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PartitionUsagesResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PartitionUsageInner>> listUsagesSinglePageAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listUsages(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, this.client.getApiVersion(), filter, "application/json", context).map(res -> new PagedResponseBase<Object, PartitionUsageInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PartitionUsagesResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PartitionUsageInner> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        return new PagedFlux<PartitionUsageInner>(() -> this.listUsagesSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PartitionUsageInner> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        String filter = null;
        return new PagedFlux<PartitionUsageInner>(() -> this.listUsagesSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PartitionUsageInner> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, Context context) {
        return new PagedFlux<PartitionUsageInner>(() -> this.listUsagesSinglePageAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PartitionUsageInner> listUsages(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        String filter = null;
        return new PagedIterable<PartitionUsageInner>(this.listUsagesAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PartitionUsageInner> listUsages(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, Context context) {
        return new PagedIterable<PartitionUsageInner>(this.listUsagesAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementCl")
    public static interface CollectionPartitionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/partitions/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PartitionMetricListResult>> listMetrics(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseRid") String var5, @PathParam(value="collectionRid") String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="$filter") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/partitions/usages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PartitionUsagesResult>> listUsages(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="databaseRid") String var5, @PathParam(value="collectionRid") String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="$filter") String var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

