/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.RestorableSqlContainersClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.RestorableSqlContainerGetResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.RestorableSqlContainersListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class RestorableSqlContainersClientImpl
implements RestorableSqlContainersClient {
    private final RestorableSqlContainersService service;
    private final CosmosDBManagementClientImpl client;

    RestorableSqlContainersClientImpl(CosmosDBManagementClientImpl client) {
        this.service = RestProxy.create(RestorableSqlContainersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RestorableSqlContainerGetResultInner>> listSinglePageAsync(String location, String instanceId, String restorableSqlDatabaseRid, String startTime, String endTime) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, instanceId, restorableSqlDatabaseRid, startTime, endTime, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RestorableSqlContainerGetResultInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RestorableSqlContainersListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RestorableSqlContainerGetResultInner>> listSinglePageAsync(String location, String instanceId, String restorableSqlDatabaseRid, String startTime, String endTime, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error(new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, instanceId, restorableSqlDatabaseRid, startTime, endTime, "application/json", context).map(res -> new PagedResponseBase<Object, RestorableSqlContainerGetResultInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RestorableSqlContainersListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RestorableSqlContainerGetResultInner> listAsync(String location, String instanceId, String restorableSqlDatabaseRid, String startTime, String endTime) {
        return new PagedFlux<RestorableSqlContainerGetResultInner>(() -> this.listSinglePageAsync(location, instanceId, restorableSqlDatabaseRid, startTime, endTime));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RestorableSqlContainerGetResultInner> listAsync(String location, String instanceId) {
        String restorableSqlDatabaseRid = null;
        String startTime = null;
        String endTime = null;
        return new PagedFlux<RestorableSqlContainerGetResultInner>(() -> this.listSinglePageAsync(location, instanceId, restorableSqlDatabaseRid, startTime, endTime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RestorableSqlContainerGetResultInner> listAsync(String location, String instanceId, String restorableSqlDatabaseRid, String startTime, String endTime, Context context) {
        return new PagedFlux<RestorableSqlContainerGetResultInner>(() -> this.listSinglePageAsync(location, instanceId, restorableSqlDatabaseRid, startTime, endTime, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RestorableSqlContainerGetResultInner> list(String location, String instanceId) {
        String restorableSqlDatabaseRid = null;
        String startTime = null;
        String endTime = null;
        return new PagedIterable<RestorableSqlContainerGetResultInner>(this.listAsync(location, instanceId, restorableSqlDatabaseRid, startTime, endTime));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RestorableSqlContainerGetResultInner> list(String location, String instanceId, String restorableSqlDatabaseRid, String startTime, String endTime, Context context) {
        return new PagedIterable<RestorableSqlContainerGetResultInner>(this.listAsync(location, instanceId, restorableSqlDatabaseRid, startTime, endTime, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementCl")
    public static interface RestorableSqlContainersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{instanceId}/restorableSqlContainers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RestorableSqlContainersListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @PathParam(value="instanceId") String var5, @QueryParam(value="restorableSqlDatabaseRid") String var6, @QueryParam(value="startTime") String var7, @QueryParam(value="endTime") String var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

