/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.PartitionKind;
import java.io.IOException;
import java.util.List;

public final class ContainerPartitionKey
implements JsonSerializable<ContainerPartitionKey> {
    private List<String> paths;
    private PartitionKind kind;
    private Integer version;
    private Boolean systemKey;

    public List<String> paths() {
        return this.paths;
    }

    public ContainerPartitionKey withPaths(List<String> paths) {
        this.paths = paths;
        return this;
    }

    public PartitionKind kind() {
        return this.kind;
    }

    public ContainerPartitionKey withKind(PartitionKind kind) {
        this.kind = kind;
        return this;
    }

    public Integer version() {
        return this.version;
    }

    public ContainerPartitionKey withVersion(Integer version) {
        this.version = version;
        return this;
    }

    public Boolean systemKey() {
        return this.systemKey;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("paths", this.paths, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeNumberField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    public static ContainerPartitionKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerPartitionKey deserializedContainerPartitionKey = new ContainerPartitionKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("paths".equals(fieldName)) {
                    List<String> paths = reader.readArray(reader1 -> reader1.getString());
                    deserializedContainerPartitionKey.paths = paths;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedContainerPartitionKey.kind = PartitionKind.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedContainerPartitionKey.version = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("systemKey".equals(fieldName)) {
                    deserializedContainerPartitionKey.systemKey = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerPartitionKey;
        });
    }
}

