/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;

public final class CorsPolicy
implements JsonSerializable<CorsPolicy> {
    private String allowedOrigins;
    private String allowedMethods;
    private String allowedHeaders;
    private String exposedHeaders;
    private Long maxAgeInSeconds;
    private static final ClientLogger LOGGER = new ClientLogger(CorsPolicy.class);

    public String allowedOrigins() {
        return this.allowedOrigins;
    }

    public CorsPolicy withAllowedOrigins(String allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public String allowedMethods() {
        return this.allowedMethods;
    }

    public CorsPolicy withAllowedMethods(String allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    public String allowedHeaders() {
        return this.allowedHeaders;
    }

    public CorsPolicy withAllowedHeaders(String allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    public String exposedHeaders() {
        return this.exposedHeaders;
    }

    public CorsPolicy withExposedHeaders(String exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
        return this;
    }

    public Long maxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public CorsPolicy withMaxAgeInSeconds(Long maxAgeInSeconds) {
        this.maxAgeInSeconds = maxAgeInSeconds;
        return this;
    }

    public void validate() {
        if (this.allowedOrigins() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property allowedOrigins in model CorsPolicy"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("allowedOrigins", this.allowedOrigins);
        jsonWriter.writeStringField("allowedMethods", this.allowedMethods);
        jsonWriter.writeStringField("allowedHeaders", this.allowedHeaders);
        jsonWriter.writeStringField("exposedHeaders", this.exposedHeaders);
        jsonWriter.writeNumberField("maxAgeInSeconds", this.maxAgeInSeconds);
        return jsonWriter.writeEndObject();
    }

    public static CorsPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CorsPolicy deserializedCorsPolicy = new CorsPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowedOrigins".equals(fieldName)) {
                    deserializedCorsPolicy.allowedOrigins = reader.getString();
                    continue;
                }
                if ("allowedMethods".equals(fieldName)) {
                    deserializedCorsPolicy.allowedMethods = reader.getString();
                    continue;
                }
                if ("allowedHeaders".equals(fieldName)) {
                    deserializedCorsPolicy.allowedHeaders = reader.getString();
                    continue;
                }
                if ("exposedHeaders".equals(fieldName)) {
                    deserializedCorsPolicy.exposedHeaders = reader.getString();
                    continue;
                }
                if ("maxAgeInSeconds".equals(fieldName)) {
                    deserializedCorsPolicy.maxAgeInSeconds = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCorsPolicy;
        });
    }
}

