/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CreateMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.MongoDBCollectionResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.MongoIndex;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MongoDBCollectionGetPropertiesResource
extends MongoDBCollectionResource {
    private String rid;
    private Float ts;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDBCollectionGetPropertiesResource.class);

    public String rid() {
        return this.rid;
    }

    public Float ts() {
        return this.ts;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public MongoDBCollectionGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public MongoDBCollectionGetPropertiesResource withShardKey(Map<String, String> shardKey) {
        super.withShardKey(shardKey);
        return this;
    }

    @Override
    public MongoDBCollectionGetPropertiesResource withIndexes(List<MongoIndex> indexes) {
        super.withIndexes(indexes);
        return this;
    }

    @Override
    public MongoDBCollectionGetPropertiesResource withAnalyticalStorageTtl(Integer analyticalStorageTtl) {
        super.withAnalyticalStorageTtl(analyticalStorageTtl);
        return this;
    }

    @Override
    public MongoDBCollectionGetPropertiesResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        super.withRestoreParameters(restoreParameters);
        return this;
    }

    @Override
    public MongoDBCollectionGetPropertiesResource withCreateMode(CreateMode createMode) {
        super.withCreateMode(createMode);
        return this;
    }

    @Override
    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property id in model MongoDBCollectionGetPropertiesResource"));
        }
        if (this.indexes() != null) {
            this.indexes().forEach(e -> e.validate());
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeMapField("shardKey", this.shardKey(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("indexes", this.indexes(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeNumberField("analyticalStorageTtl", this.analyticalStorageTtl());
        jsonWriter.writeJsonField("restoreParameters", this.restoreParameters());
        jsonWriter.writeStringField("createMode", this.createMode() == null ? null : this.createMode().toString());
        return jsonWriter.writeEndObject();
    }

    public static MongoDBCollectionGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MongoDBCollectionGetPropertiesResource deserializedMongoDBCollectionGetPropertiesResource = new MongoDBCollectionGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource.withId(reader.getString());
                    continue;
                }
                if ("shardKey".equals(fieldName)) {
                    Map<String, String> shardKey = reader.readMap(reader1 -> reader1.getString());
                    deserializedMongoDBCollectionGetPropertiesResource.withShardKey((Map)shardKey);
                    continue;
                }
                if ("indexes".equals(fieldName)) {
                    List<MongoIndex> indexes = reader.readArray(reader1 -> MongoIndex.fromJson(reader1));
                    deserializedMongoDBCollectionGetPropertiesResource.withIndexes((List)indexes);
                    continue;
                }
                if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource.withAnalyticalStorageTtl(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource.withRestoreParameters(ResourceRestoreParameters.fromJson(reader));
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource.withCreateMode(CreateMode.fromString(reader.getString()));
                    continue;
                }
                if ("_rid".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource.rid = reader.getString();
                    continue;
                }
                if ("_ts".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource.ts = reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("_etag".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDBCollectionGetPropertiesResource;
        });
    }
}

