/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.DataTransferServiceResourceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.GraphApiComputeServiceResourceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.MaterializedViewsBuilderServiceResourceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ServiceSize;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ServiceStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ServiceType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.SqlDedicatedGatewayServiceResourceProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public class ServiceResourceProperties
implements JsonSerializable<ServiceResourceProperties> {
    private ServiceType serviceType = ServiceType.fromString("ServiceResourceProperties");
    private OffsetDateTime creationTime;
    private ServiceSize instanceSize;
    private Integer instanceCount;
    private ServiceStatus status;
    private Map<String, Object> additionalProperties;

    public ServiceType serviceType() {
        return this.serviceType;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    ServiceResourceProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public ServiceSize instanceSize() {
        return this.instanceSize;
    }

    public ServiceResourceProperties withInstanceSize(ServiceSize instanceSize) {
        this.instanceSize = instanceSize;
        return this;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public ServiceResourceProperties withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public ServiceStatus status() {
        return this.status;
    }

    ServiceResourceProperties withStatus(ServiceStatus status) {
        this.status = status;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public ServiceResourceProperties withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        jsonWriter.writeStringField("instanceSize", this.instanceSize == null ? null : this.instanceSize.toString());
        jsonWriter.writeNumberField("instanceCount", this.instanceCount);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ServiceResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ServiceResourceProperties serviceResourceProperties;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("serviceType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("DataTransfer".equals(discriminatorValue)) {
                    serviceResourceProperties = DataTransferServiceResourceProperties.fromJson(readerToUse.reset());
                    return serviceResourceProperties;
                }
                if ("SqlDedicatedGateway".equals(discriminatorValue)) {
                    serviceResourceProperties = SqlDedicatedGatewayServiceResourceProperties.fromJson(readerToUse.reset());
                    return serviceResourceProperties;
                }
                if ("GraphAPICompute".equals(discriminatorValue)) {
                    serviceResourceProperties = GraphApiComputeServiceResourceProperties.fromJson(readerToUse.reset());
                    return serviceResourceProperties;
                }
                if ("MaterializedViewsBuilder".equals(discriminatorValue)) {
                    serviceResourceProperties = MaterializedViewsBuilderServiceResourceProperties.fromJson(readerToUse.reset());
                    return serviceResourceProperties;
                }
                serviceResourceProperties = ServiceResourceProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return serviceResourceProperties;
            }
        });
    }

    static ServiceResourceProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceResourceProperties deserializedServiceResourceProperties = new ServiceResourceProperties();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceType".equals(fieldName)) {
                    deserializedServiceResourceProperties.serviceType = ServiceType.fromString(reader.getString());
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedServiceResourceProperties.creationTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("instanceSize".equals(fieldName)) {
                    deserializedServiceResourceProperties.instanceSize = ServiceSize.fromString(reader.getString());
                    continue;
                }
                if ("instanceCount".equals(fieldName)) {
                    deserializedServiceResourceProperties.instanceCount = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedServiceResourceProperties.status = ServiceStatus.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedServiceResourceProperties.additionalProperties = additionalProperties;
            return deserializedServiceResourceProperties;
        });
    }
}

