/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.fluent.models.ThroughputSettingsUpdateProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ThroughputSettingsResource;
import java.io.IOException;
import java.util.Map;

public final class ThroughputSettingsUpdateParameters
extends ArmResourceProperties {
    private ThroughputSettingsUpdateProperties innerProperties = new ThroughputSettingsUpdateProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ThroughputSettingsUpdateParameters.class);

    private ThroughputSettingsUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ThroughputSettingsUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public ThroughputSettingsUpdateParameters withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public ThroughputSettingsResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public ThroughputSettingsUpdateParameters withResource(ThroughputSettingsResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ThroughputSettingsUpdateProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property innerProperties in model ThroughputSettingsUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ThroughputSettingsUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ThroughputSettingsUpdateParameters deserializedThroughputSettingsUpdateParameters = new ThroughputSettingsUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedThroughputSettingsUpdateParameters.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedThroughputSettingsUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedThroughputSettingsUpdateParameters.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedThroughputSettingsUpdateParameters.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedThroughputSettingsUpdateParameters.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedThroughputSettingsUpdateParameters.innerProperties = ThroughputSettingsUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedThroughputSettingsUpdateParameters;
        });
    }
}

