/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation.DnsRecordSetImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation.DnsZoneImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.AaaaRecord;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.AaaaRecordSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.RecordType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class AaaaRecordSetImpl
extends DnsRecordSetImpl
implements AaaaRecordSet {
    AaaaRecordSetImpl(String name, DnsZoneImpl parent, RecordSetInner innerModel) {
        super(name, RecordType.AAAA.toString(), parent, innerModel);
    }

    static AaaaRecordSetImpl newRecordSet(String name, DnsZoneImpl parent) {
        return new AaaaRecordSetImpl(name, parent, new RecordSetInner().withAaaaRecords(new ArrayList<AaaaRecord>()));
    }

    @Override
    public List<String> ipv6Addresses() {
        ArrayList<String> ipv6Addresses = new ArrayList<String>();
        if (((RecordSetInner)this.innerModel()).aaaaRecords() != null) {
            for (AaaaRecord aaaaRecord : ((RecordSetInner)this.innerModel()).aaaaRecords()) {
                ipv6Addresses.add(aaaaRecord.ipv6Address());
            }
        }
        return Collections.unmodifiableList(ipv6Addresses);
    }

    @Override
    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        if (((RecordSetInner)this.innerModel()).aaaaRecords() != null && ((RecordSetInner)this.innerModel()).aaaaRecords().size() > 0) {
            if (resource.aaaaRecords() == null) {
                resource.withAaaaRecords(new ArrayList<AaaaRecord>());
            }
            resource.aaaaRecords().addAll(((RecordSetInner)this.innerModel()).aaaaRecords());
            ((RecordSetInner)this.innerModel()).aaaaRecords().clear();
        }
        if (this.recordSetRemoveInfo.aaaaRecords().size() > 0) {
            if (resource.aaaaRecords() != null) {
                block0: for (AaaaRecord recordToRemove : this.recordSetRemoveInfo.aaaaRecords()) {
                    for (AaaaRecord record : resource.aaaaRecords()) {
                        if (!record.ipv6Address().equalsIgnoreCase(recordToRemove.ipv6Address())) continue;
                        resource.aaaaRecords().remove(record);
                        continue block0;
                    }
                }
            }
            this.recordSetRemoveInfo.aaaaRecords().clear();
        }
        return resource;
    }
}

