/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.DnsZoneManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.fluent.DnsManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation.DnsZoneImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.ARecord;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.AaaaRecord;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.CaaRecord;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.CnameRecord;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.DnsRecordSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.DnsZone;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.MxRecord;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.NsRecord;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.PtrRecord;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.RecordType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.SrvRecord;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.TxtRecord;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ETagState;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class DnsRecordSetImpl
extends ExternalChildResourceImpl<DnsRecordSet, RecordSetInner, DnsZoneImpl, DnsZone>
implements DnsRecordSet,
DnsRecordSet.Definition<DnsZone.DefinitionStages.WithCreate>,
DnsRecordSet.UpdateDefinition<DnsZone.Update>,
DnsRecordSet.UpdateCombined {
    protected final RecordSetInner recordSetRemoveInfo;
    protected final String type;
    private final ETagState etagState = new ETagState();

    protected DnsRecordSetImpl(String name, String type, DnsZoneImpl parent, RecordSetInner innerModel) {
        super(name, parent, innerModel);
        this.type = type;
        this.recordSetRemoveInfo = new RecordSetInner().withARecords(new ArrayList<ARecord>()).withAaaaRecords(new ArrayList<AaaaRecord>()).withCaaRecords(new ArrayList<CaaRecord>()).withCnameRecord(new CnameRecord()).withMxRecords(new ArrayList<MxRecord>()).withNsRecords(new ArrayList<NsRecord>()).withPtrRecords(new ArrayList<PtrRecord>()).withSrvRecords(new ArrayList<SrvRecord>()).withTxtRecords(new ArrayList<TxtRecord>()).withMetadata(new LinkedHashMap<String, String>());
    }

    @Override
    public String id() {
        return ((RecordSetInner)this.innerModel()).id();
    }

    @Override
    public RecordType recordType() {
        String fullyQualifiedType = this.type;
        String[] parts = fullyQualifiedType.split("/");
        return RecordType.fromString(parts[parts.length - 1]);
    }

    @Override
    public long timeToLive() {
        return ((RecordSetInner)this.innerModel()).ttl();
    }

    @Override
    public Map<String, String> metadata() {
        if (((RecordSetInner)this.innerModel()).metadata() == null) {
            return Collections.unmodifiableMap(new LinkedHashMap());
        }
        return Collections.unmodifiableMap(((RecordSetInner)this.innerModel()).metadata());
    }

    @Override
    public String fqdn() {
        return ((RecordSetInner)this.innerModel()).fqdn();
    }

    @Override
    public String etag() {
        return ((RecordSetInner)this.innerModel()).etag();
    }

    @Override
    public DnsRecordSetImpl withIPv4Address(String ipv4Address) {
        ((RecordSetInner)this.innerModel()).aRecords().add(new ARecord().withIpv4Address(ipv4Address));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutIPv4Address(String ipv4Address) {
        this.recordSetRemoveInfo.aRecords().add(new ARecord().withIpv4Address(ipv4Address));
        return this;
    }

    @Override
    public DnsRecordSetImpl withIPv6Address(String ipv6Address) {
        ((RecordSetInner)this.innerModel()).aaaaRecords().add(new AaaaRecord().withIpv6Address(ipv6Address));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutIPv6Address(String ipv6Address) {
        this.recordSetRemoveInfo.aaaaRecords().add(new AaaaRecord().withIpv6Address(ipv6Address));
        return this;
    }

    @Override
    public DnsRecordSetImpl withAlias(String alias) {
        ((RecordSetInner)this.innerModel()).cnameRecord().withCname(alias);
        return this;
    }

    @Override
    public DnsRecordSetImpl withMailExchange(String mailExchangeHostName, int priority) {
        ((RecordSetInner)this.innerModel()).mxRecords().add(new MxRecord().withExchange(mailExchangeHostName).withPreference(priority));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutMailExchange(String mailExchangeHostName, int priority) {
        this.recordSetRemoveInfo.mxRecords().add(new MxRecord().withExchange(mailExchangeHostName).withPreference(priority));
        return this;
    }

    @Override
    public DnsRecordSetImpl withNameServer(String nameServerHostName) {
        ((RecordSetInner)this.innerModel()).nsRecords().add(new NsRecord().withNsdname(nameServerHostName));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutNameServer(String nameServerHostName) {
        this.recordSetRemoveInfo.nsRecords().add(new NsRecord().withNsdname(nameServerHostName));
        return this;
    }

    @Override
    public DnsRecordSetImpl withTargetDomainName(String targetDomainName) {
        ((RecordSetInner)this.innerModel()).ptrRecords().add(new PtrRecord().withPtrdname(targetDomainName));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutTargetDomainName(String targetDomainName) {
        this.recordSetRemoveInfo.ptrRecords().add(new PtrRecord().withPtrdname(targetDomainName));
        return this;
    }

    @Override
    public DnsRecordSetImpl withRecord(int flags, String tag, String value) {
        ((RecordSetInner)this.innerModel()).caaRecords().add(new CaaRecord().withFlags(flags).withTag(tag).withValue(value));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutRecord(int flags, String tag, String value) {
        this.recordSetRemoveInfo.caaRecords().add(new CaaRecord().withFlags(flags).withTag(tag).withValue(value));
        return this;
    }

    @Override
    public DnsRecordSetImpl withRecord(String target, int port, int priority, int weight) {
        ((RecordSetInner)this.innerModel()).srvRecords().add(new SrvRecord().withTarget(target).withPort(port).withPriority(priority).withWeight(weight));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutRecord(String target, int port, int priority, int weight) {
        this.recordSetRemoveInfo.srvRecords().add(new SrvRecord().withTarget(target).withPort(port).withPriority(priority).withWeight(weight));
        return this;
    }

    @Override
    public DnsRecordSetImpl withText(String text) {
        if (text == null) {
            return this;
        }
        ArrayList<String> chunks = new ArrayList<String>();
        for (String chunk : text.split("(?<=\\G.{250})")) {
            chunks.add(chunk);
        }
        ((RecordSetInner)this.innerModel()).txtRecords().add(new TxtRecord().withValue(chunks));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutText(String text) {
        if (text == null) {
            return this;
        }
        ArrayList<String> chunks = new ArrayList<String>();
        chunks.add(text);
        return this.withoutText(chunks);
    }

    @Override
    public DnsRecordSetImpl withoutText(List<String> textChunks) {
        this.recordSetRemoveInfo.txtRecords().add(new TxtRecord().withValue(textChunks));
        return this;
    }

    @Override
    public DnsRecordSetImpl withEmailServer(String emailServerHostName) {
        ((RecordSetInner)this.innerModel()).soaRecord().withEmail(emailServerHostName);
        return this;
    }

    @Override
    public DnsRecordSetImpl withRefreshTimeInSeconds(long refreshTimeInSeconds) {
        ((RecordSetInner)this.innerModel()).soaRecord().withRefreshTime(refreshTimeInSeconds);
        return this;
    }

    @Override
    public DnsRecordSetImpl withRetryTimeInSeconds(long retryTimeInSeconds) {
        ((RecordSetInner)this.innerModel()).soaRecord().withRetryTime(retryTimeInSeconds);
        return this;
    }

    @Override
    public DnsRecordSetImpl withExpireTimeInSeconds(long expireTimeInSeconds) {
        ((RecordSetInner)this.innerModel()).soaRecord().withExpireTime(expireTimeInSeconds);
        return this;
    }

    @Override
    public DnsRecordSetImpl withNegativeResponseCachingTimeToLiveInSeconds(long negativeCachingTimeToLive) {
        ((RecordSetInner)this.innerModel()).soaRecord().withMinimumTtl(negativeCachingTimeToLive);
        return this;
    }

    @Override
    public DnsRecordSetImpl withSerialNumber(long serialNumber) {
        ((RecordSetInner)this.innerModel()).soaRecord().withSerialNumber(serialNumber);
        return this;
    }

    @Override
    public DnsRecordSetImpl withTimeToLive(long ttlInSeconds) {
        ((RecordSetInner)this.innerModel()).withTtl(ttlInSeconds);
        return this;
    }

    @Override
    public DnsRecordSetImpl withMetadata(String key, String value) {
        if (((RecordSetInner)this.innerModel()).metadata() == null) {
            ((RecordSetInner)this.innerModel()).withMetadata(new LinkedHashMap<String, String>());
        }
        ((RecordSetInner)this.innerModel()).metadata().put(key, value);
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutMetadata(String key) {
        this.recordSetRemoveInfo.metadata().put(key, null);
        return this;
    }

    @Override
    public DnsRecordSetImpl withETagCheck() {
        this.etagState.withImplicitETagCheckOnCreateOrUpdate(this.isInCreateMode());
        return this;
    }

    @Override
    public DnsRecordSetImpl withETagCheck(String etagValue) {
        this.etagState.withExplicitETagCheckOnUpdate(etagValue);
        return this;
    }

    @Override
    public Mono<DnsRecordSet> createResourceAsync() {
        return this.createOrUpdateAsync((RecordSetInner)this.innerModel());
    }

    @Override
    public Mono<DnsRecordSet> updateResourceAsync() {
        return ((DnsManagementClient)((DnsZoneManager)((DnsZoneImpl)this.parent()).manager()).serviceClient()).getRecordSets().getAsync(((DnsZoneImpl)this.parent()).resourceGroupName(), ((DnsZoneImpl)this.parent()).name(), this.name(), this.recordType()).map(recordSetInner -> this.prepare((RecordSetInner)recordSetInner)).flatMap(recordSetInner -> this.createOrUpdateAsync((RecordSetInner)recordSetInner));
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return ((DnsManagementClient)((DnsZoneManager)((DnsZoneImpl)this.parent()).manager()).serviceClient()).getRecordSets().deleteWithResponseAsync(((DnsZoneImpl)this.parent()).resourceGroupName(), ((DnsZoneImpl)this.parent()).name(), this.name(), this.recordType(), this.etagState.ifMatchValueOnDelete()).then();
    }

    @Override
    public DnsZoneImpl attach() {
        return (DnsZoneImpl)this.parent();
    }

    @Override
    public String childResourceKey() {
        return this.name() + "_" + this.recordType().toString();
    }

    @Override
    protected Mono<RecordSetInner> getInnerAsync() {
        return ((DnsManagementClient)((DnsZoneManager)((DnsZoneImpl)this.parent()).manager()).serviceClient()).getRecordSets().getAsync(((DnsZoneImpl)this.parent()).resourceGroupName(), ((DnsZoneImpl)this.parent()).name(), this.name(), this.recordType());
    }

    private Mono<DnsRecordSet> createOrUpdateAsync(RecordSetInner resource) {
        DnsRecordSetImpl self = this;
        return ((DnsManagementClient)((DnsZoneManager)((DnsZoneImpl)this.parent()).manager()).serviceClient()).getRecordSets().createOrUpdateWithResponseAsync(((DnsZoneImpl)this.parent()).resourceGroupName(), ((DnsZoneImpl)this.parent()).name(), this.name(), this.recordType(), resource, this.etagState.ifMatchValueOnUpdate(resource.etag()), this.etagState.ifNonMatchValueOnCreate()).map(recordSetInner -> {
            this.setInner((RecordSetInner)recordSetInner.getValue());
            self.etagState.clear();
            return self;
        });
    }

    private RecordSetInner prepare(RecordSetInner resource) {
        if (this.recordSetRemoveInfo.metadata().size() > 0) {
            if (resource.metadata() != null) {
                for (String string : this.recordSetRemoveInfo.metadata().keySet()) {
                    resource.metadata().remove(string);
                }
            }
            this.recordSetRemoveInfo.metadata().clear();
        }
        if (((RecordSetInner)this.innerModel()).metadata() != null && ((RecordSetInner)this.innerModel()).metadata().size() > 0) {
            if (resource.metadata() == null) {
                resource.withMetadata(new LinkedHashMap<String, String>());
            }
            for (Map.Entry entry : ((RecordSetInner)this.innerModel()).metadata().entrySet()) {
                resource.metadata().put((String)entry.getKey(), (String)entry.getValue());
            }
            ((RecordSetInner)this.innerModel()).metadata().clear();
        }
        if (((RecordSetInner)this.innerModel()).ttl() != null) {
            resource.withTtl(((RecordSetInner)this.innerModel()).ttl());
            ((RecordSetInner)this.innerModel()).withTtl(null);
        }
        return this.prepareForUpdate(resource);
    }

    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        return resource;
    }

    DnsRecordSetImpl withETagOnDelete(String etagValue) {
        this.etagState.withExplicitETagCheckOnDelete(etagValue);
        return this;
    }

    private boolean isInCreateMode() {
        return ((RecordSetInner)this.innerModel()).id() == null;
    }
}

