/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.DnsZoneManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.fluent.DnsManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.fluent.ZonesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.fluent.models.ZoneInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation.DnsZoneImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.DnsZone;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.DnsZones;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class DnsZonesImpl
extends TopLevelModifiableResourcesImpl<DnsZone, DnsZoneImpl, ZoneInner, ZonesClient, DnsZoneManager>
implements DnsZones {
    public DnsZonesImpl(DnsZoneManager dnsZoneManager) {
        super(((DnsManagementClient)dnsZoneManager.serviceClient()).getZones(), dnsZoneManager);
    }

    @Override
    public DnsZoneImpl define(String name) {
        return this.setDefaults(this.wrapModel(name));
    }

    @Override
    protected DnsZoneImpl wrapModel(String name) {
        return new DnsZoneImpl(name, new ZoneInner(), (DnsZoneManager)this.manager());
    }

    @Override
    protected DnsZoneImpl wrapModel(ZoneInner inner) {
        if (inner == null) {
            return null;
        }
        return new DnsZoneImpl(inner.name(), inner, (DnsZoneManager)this.manager());
    }

    private DnsZoneImpl setDefaults(DnsZoneImpl dnsZone) {
        ((ZoneInner)dnsZone.innerModel()).withLocation("global");
        return dnsZone;
    }

    @Override
    public Mono<Void> deleteByResourceGroupNameAsync(String resourceGroupName, String zoneName) {
        return ((DnsManagementClient)((DnsZoneManager)this.manager()).serviceClient()).getZones().deleteAsync(resourceGroupName, zoneName);
    }

    @Override
    public Mono<Void> deleteByResourceGroupNameAsync(String resourceGroupName, String zoneName, String eTagValue) {
        return ((DnsManagementClient)((DnsZoneManager)this.manager()).serviceClient()).getZones().deleteAsync(resourceGroupName, zoneName, eTagValue);
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        return this.deleteByResourceGroupNameAsync(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id, String eTagValue) {
        return this.deleteByResourceGroupNameAsync(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id), eTagValue);
    }

    @Override
    public void deleteByResourceGroupName(String resourceGroupName, String zoneName) {
        this.deleteByResourceGroupNameAsync(resourceGroupName, zoneName).block();
    }

    @Override
    public void deleteByResourceGroupName(String resourceGroupName, String zoneName, String eTagValue) {
        this.deleteByResourceGroupNameAsync(resourceGroupName, zoneName, eTagValue).block();
    }

    @Override
    public void deleteById(String id) {
        this.deleteByIdAsync(id).block();
    }

    @Override
    public void deleteById(String id, String eTagValue) {
        this.deleteByIdAsync(id, eTagValue).block();
    }
}

