/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Patch;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.fluent.RecordSetsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.implementation.DnsManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.RecordSetListResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.RecordType;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class RecordSetsClientImpl
implements RecordSetsClient {
    private final RecordSetsService service;
    private final DnsManagementClientImpl client;

    RecordSetsClientImpl(DnsManagementClientImpl client) {
        this.service = RestProxy.create(RecordSetsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordSetInner>> updateWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecordSetInner>> updateWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> updateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        String ifMatch = null;
        return this.updateWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch).flatMap(res -> Mono.justOrEmpty((RecordSetInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordSetInner> updateWithResponse(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, Context context) {
        return this.updateWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordSetInner update(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        String ifMatch = null;
        return this.updateWithResponse(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordSetInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, ifNoneMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecordSetInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, ifNoneMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((RecordSetInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordSetInner> createOrUpdateWithResponse(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordSetInner createOrUpdate(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.createOrUpdateWithResponse(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        String ifMatch = null;
        return this.deleteWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch, Context context) {
        return this.deleteWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        String ifMatch = null;
        this.deleteWithResponse(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordSetInner>> getWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecordSetInner>> getWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> getAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        return this.getWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType).flatMap(res -> Mono.justOrEmpty((RecordSetInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordSetInner> getWithResponse(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, Context context) {
        return this.getWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordSetInner get(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        return this.getWithResponse(resourceGroupName, zoneName, relativeRecordSetName, recordType, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeSinglePageAsync(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByType(this.client.getEndpoint(), resourceGroupName, zoneName, recordType, top, recordsetnamesuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RecordSetInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeSinglePageAsync(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByType(this.client.getEndpoint(), resourceGroupName, zoneName, recordType, top, recordsetnamesuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase<Object, RecordSetInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listByTypeAsync(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix) {
        return new PagedFlux<RecordSetInner>(() -> this.listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix), nextLink -> this.listByTypeNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listByTypeAsync(String resourceGroupName, String zoneName, RecordType recordType) {
        Integer top = null;
        String recordsetnamesuffix = null;
        return new PagedFlux<RecordSetInner>(() -> this.listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix), nextLink -> this.listByTypeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RecordSetInner> listByTypeAsync(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedFlux<RecordSetInner>(() -> this.listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix, context), nextLink -> this.listByTypeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listByType(String resourceGroupName, String zoneName, RecordType recordType) {
        Integer top = null;
        String recordsetnamesuffix = null;
        return new PagedIterable<RecordSetInner>(this.listByTypeAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listByType(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedIterable<RecordSetInner>(this.listByTypeAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByDnsZoneSinglePageAsync(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDnsZone(this.client.getEndpoint(), resourceGroupName, zoneName, top, recordsetnamesuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RecordSetInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByDnsZoneSinglePageAsync(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDnsZone(this.client.getEndpoint(), resourceGroupName, zoneName, top, recordsetnamesuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase<Object, RecordSetInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listByDnsZoneAsync(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix) {
        return new PagedFlux<RecordSetInner>(() -> this.listByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordsetnamesuffix), nextLink -> this.listByDnsZoneNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listByDnsZoneAsync(String resourceGroupName, String zoneName) {
        Integer top = null;
        String recordsetnamesuffix = null;
        return new PagedFlux<RecordSetInner>(() -> this.listByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordsetnamesuffix), nextLink -> this.listByDnsZoneNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RecordSetInner> listByDnsZoneAsync(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedFlux<RecordSetInner>(() -> this.listByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordsetnamesuffix, context), nextLink -> this.listByDnsZoneNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listByDnsZone(String resourceGroupName, String zoneName) {
        Integer top = null;
        String recordsetnamesuffix = null;
        return new PagedIterable<RecordSetInner>(this.listByDnsZoneAsync(resourceGroupName, zoneName, top, recordsetnamesuffix));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listByDnsZone(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedIterable<RecordSetInner>(this.listByDnsZoneAsync(resourceGroupName, zoneName, top, recordsetnamesuffix, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listAllByDnsZoneSinglePageAsync(String resourceGroupName, String zoneName, Integer top, String recordSetNameSuffix) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAllByDnsZone(this.client.getEndpoint(), resourceGroupName, zoneName, top, recordSetNameSuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RecordSetInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listAllByDnsZoneSinglePageAsync(String resourceGroupName, String zoneName, Integer top, String recordSetNameSuffix, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error(new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAllByDnsZone(this.client.getEndpoint(), resourceGroupName, zoneName, top, recordSetNameSuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase<Object, RecordSetInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listAllByDnsZoneAsync(String resourceGroupName, String zoneName, Integer top, String recordSetNameSuffix) {
        return new PagedFlux<RecordSetInner>(() -> this.listAllByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordSetNameSuffix), nextLink -> this.listAllByDnsZoneNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listAllByDnsZoneAsync(String resourceGroupName, String zoneName) {
        Integer top = null;
        String recordSetNameSuffix = null;
        return new PagedFlux<RecordSetInner>(() -> this.listAllByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordSetNameSuffix), nextLink -> this.listAllByDnsZoneNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RecordSetInner> listAllByDnsZoneAsync(String resourceGroupName, String zoneName, Integer top, String recordSetNameSuffix, Context context) {
        return new PagedFlux<RecordSetInner>(() -> this.listAllByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordSetNameSuffix, context), nextLink -> this.listAllByDnsZoneNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listAllByDnsZone(String resourceGroupName, String zoneName) {
        Integer top = null;
        String recordSetNameSuffix = null;
        return new PagedIterable<RecordSetInner>(this.listAllByDnsZoneAsync(resourceGroupName, zoneName, top, recordSetNameSuffix));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listAllByDnsZone(String resourceGroupName, String zoneName, Integer top, String recordSetNameSuffix, Context context) {
        return new PagedIterable<RecordSetInner>(this.listAllByDnsZoneAsync(resourceGroupName, zoneName, top, recordSetNameSuffix, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByTypeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RecordSetInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByTypeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, RecordSetInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByDnsZoneNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDnsZoneNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RecordSetInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByDnsZoneNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDnsZoneNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, RecordSetInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listAllByDnsZoneNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAllByDnsZoneNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, RecordSetInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listAllByDnsZoneNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAllByDnsZoneNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, RecordSetInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DnsManagementClientR")
    public static interface RecordSetsService {
        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @PathParam(value="relativeRecordSetName", encoded=true) String var4, @PathParam(value="recordType") RecordType var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") RecordSetInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @PathParam(value="relativeRecordSetName", encoded=true) String var4, @PathParam(value="recordType") RecordType var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @BodyParam(value="application/json") RecordSetInner var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @PathParam(value="relativeRecordSetName", encoded=true) String var4, @PathParam(value="recordType") RecordType var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @PathParam(value="relativeRecordSetName", encoded=true) String var4, @PathParam(value="recordType") RecordType var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listByType(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @PathParam(value="recordType") RecordType var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$recordsetnamesuffix") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/recordsets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listByDnsZone(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$recordsetnamesuffix") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/all")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listAllByDnsZone(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$recordsetnamesuffix") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listByTypeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listByDnsZoneNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listAllByDnsZoneNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

