/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models.AccessKeysInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models.AuthorizationRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.Ancestors;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation.AuthorizationRuleBaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHub;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubAuthorizationRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.KeyType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.RegenerateAccessKeyParameters;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

class EventHubAuthorizationRuleImpl
extends AuthorizationRuleBaseImpl<EventHubAuthorizationRule, EventHubAuthorizationRuleImpl>
implements EventHubAuthorizationRule,
EventHubAuthorizationRule.Definition,
EventHubAuthorizationRule.Update {
    private Ancestors.TwoAncestor ancestor;

    EventHubAuthorizationRuleImpl(String name, AuthorizationRuleInner inner, EventHubsManager manager) {
        super(name, inner, manager);
        this.ancestor = new Ancestors.TwoAncestor(new Ancestors(), inner.id());
    }

    EventHubAuthorizationRuleImpl(String name, EventHubsManager manager) {
        super(name, new AuthorizationRuleInner(), manager);
    }

    @Override
    public String namespaceResourceGroupName() {
        return this.ancestor().resourceGroupName();
    }

    @Override
    public String namespaceName() {
        return this.ancestor().ancestor2Name();
    }

    @Override
    public String eventHubName() {
        return this.ancestor().ancestor1Name();
    }

    @Override
    public EventHubAuthorizationRuleImpl withExistingEventHubId(String eventHubResourceId) {
        this.ancestor = new Ancestors.TwoAncestor(new Ancestors(), this.selfId(eventHubResourceId));
        return this;
    }

    @Override
    public EventHubAuthorizationRuleImpl withExistingEventHub(String resourceGroupName, String namespaceName, String eventHubName) {
        this.ancestor = new Ancestors.TwoAncestor(new Ancestors(), resourceGroupName, eventHubName, namespaceName);
        return this;
    }

    @Override
    public EventHubAuthorizationRuleImpl withExistingEventHub(EventHub eventHub) {
        this.ancestor = new Ancestors.TwoAncestor(new Ancestors(), this.selfId(eventHub.id()));
        return this;
    }

    @Override
    protected Mono<AuthorizationRuleInner> getInnerAsync() {
        return ((EventHubManagementClient)this.manager.serviceClient()).getEventHubs().getAuthorizationRuleAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor2Name(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public Mono<EventHubAuthorizationRule> createResourceAsync() {
        return ((EventHubManagementClient)this.manager.serviceClient()).getEventHubs().createOrUpdateAuthorizationRuleAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor2Name(), this.ancestor().ancestor1Name(), this.name(), new AuthorizationRuleInner().withRights(((AuthorizationRuleInner)this.innerModel()).rights())).map(this.innerToFluentMap(this));
    }

    @Override
    protected Mono<AccessKeysInner> getKeysInnerAsync() {
        return ((EventHubManagementClient)this.manager.serviceClient()).getEventHubs().listKeysAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor2Name(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    protected Mono<AccessKeysInner> regenerateKeysInnerAsync(KeyType keyType) {
        RegenerateAccessKeyParameters regenKeyInner = new RegenerateAccessKeyParameters().withKeyType(keyType);
        return ((EventHubManagementClient)this.manager.serviceClient()).getEventHubs().regenerateKeysAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor2Name(), this.ancestor().ancestor1Name(), this.name(), regenKeyInner);
    }

    private Ancestors.TwoAncestor ancestor() {
        Objects.requireNonNull(this.ancestor);
        return this.ancestor;
    }

    private String selfId(String parentId) {
        return String.format("%s/authorizationRules/%s", parentId, this.name());
    }
}

