/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.Destination;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EncodingCaptureDescription;
import java.io.IOException;

public final class CaptureDescription
implements JsonSerializable<CaptureDescription> {
    private Boolean enabled;
    private EncodingCaptureDescription encoding;
    private Integer intervalInSeconds;
    private Integer sizeLimitInBytes;
    private Destination destination;
    private Boolean skipEmptyArchives;

    public Boolean enabled() {
        return this.enabled;
    }

    public CaptureDescription withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public EncodingCaptureDescription encoding() {
        return this.encoding;
    }

    public CaptureDescription withEncoding(EncodingCaptureDescription encoding) {
        this.encoding = encoding;
        return this;
    }

    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public CaptureDescription withIntervalInSeconds(Integer intervalInSeconds) {
        this.intervalInSeconds = intervalInSeconds;
        return this;
    }

    public Integer sizeLimitInBytes() {
        return this.sizeLimitInBytes;
    }

    public CaptureDescription withSizeLimitInBytes(Integer sizeLimitInBytes) {
        this.sizeLimitInBytes = sizeLimitInBytes;
        return this;
    }

    public Destination destination() {
        return this.destination;
    }

    public CaptureDescription withDestination(Destination destination) {
        this.destination = destination;
        return this;
    }

    public Boolean skipEmptyArchives() {
        return this.skipEmptyArchives;
    }

    public CaptureDescription withSkipEmptyArchives(Boolean skipEmptyArchives) {
        this.skipEmptyArchives = skipEmptyArchives;
        return this;
    }

    public void validate() {
        if (this.destination() != null) {
            this.destination().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("encoding", this.encoding == null ? null : this.encoding.toString());
        jsonWriter.writeNumberField("intervalInSeconds", this.intervalInSeconds);
        jsonWriter.writeNumberField("sizeLimitInBytes", this.sizeLimitInBytes);
        jsonWriter.writeJsonField("destination", this.destination);
        jsonWriter.writeBooleanField("skipEmptyArchives", this.skipEmptyArchives);
        return jsonWriter.writeEndObject();
    }

    public static CaptureDescription fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CaptureDescription deserializedCaptureDescription = new CaptureDescription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedCaptureDescription.enabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("encoding".equals(fieldName)) {
                    deserializedCaptureDescription.encoding = EncodingCaptureDescription.fromString(reader.getString());
                    continue;
                }
                if ("intervalInSeconds".equals(fieldName)) {
                    deserializedCaptureDescription.intervalInSeconds = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("sizeLimitInBytes".equals(fieldName)) {
                    deserializedCaptureDescription.sizeLimitInBytes = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedCaptureDescription.destination = Destination.fromJson(reader);
                    continue;
                }
                if ("skipEmptyArchives".equals(fieldName)) {
                    deserializedCaptureDescription.skipEmptyArchives = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCaptureDescription;
        });
    }
}

