/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.NspAccessRuleDirection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.NspAccessRulePropertiesSubscriptionsItem;
import java.io.IOException;
import java.util.List;

public final class NspAccessRuleProperties
implements JsonSerializable<NspAccessRuleProperties> {
    private NspAccessRuleDirection direction;
    private List<String> addressPrefixes;
    private List<NspAccessRulePropertiesSubscriptionsItem> subscriptions;
    private List<NetworkSecurityPerimeter> networkSecurityPerimeters;
    private List<String> fullyQualifiedDomainNames;

    public NspAccessRuleDirection direction() {
        return this.direction;
    }

    public NspAccessRuleProperties withDirection(NspAccessRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    public NspAccessRuleProperties withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    public List<NspAccessRulePropertiesSubscriptionsItem> subscriptions() {
        return this.subscriptions;
    }

    public NspAccessRuleProperties withSubscriptions(List<NspAccessRulePropertiesSubscriptionsItem> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public List<NetworkSecurityPerimeter> networkSecurityPerimeters() {
        return this.networkSecurityPerimeters;
    }

    public List<String> fullyQualifiedDomainNames() {
        return this.fullyQualifiedDomainNames;
    }

    public void validate() {
        if (this.subscriptions() != null) {
            this.subscriptions().forEach(e -> e.validate());
        }
        if (this.networkSecurityPerimeters() != null) {
            this.networkSecurityPerimeters().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("subscriptions", this.subscriptions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static NspAccessRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspAccessRuleProperties deserializedNspAccessRuleProperties = new NspAccessRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("direction".equals(fieldName)) {
                    deserializedNspAccessRuleProperties.direction = NspAccessRuleDirection.fromString(reader.getString());
                    continue;
                }
                if ("addressPrefixes".equals(fieldName)) {
                    List<String> addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspAccessRuleProperties.addressPrefixes = addressPrefixes;
                    continue;
                }
                if ("subscriptions".equals(fieldName)) {
                    List<NspAccessRulePropertiesSubscriptionsItem> subscriptions = reader.readArray(reader1 -> NspAccessRulePropertiesSubscriptionsItem.fromJson(reader1));
                    deserializedNspAccessRuleProperties.subscriptions = subscriptions;
                    continue;
                }
                if ("networkSecurityPerimeters".equals(fieldName)) {
                    List<NetworkSecurityPerimeter> networkSecurityPerimeters = reader.readArray(reader1 -> NetworkSecurityPerimeter.fromJson(reader1));
                    deserializedNspAccessRuleProperties.networkSecurityPerimeters = networkSecurityPerimeters;
                    continue;
                }
                if ("fullyQualifiedDomainNames".equals(fieldName)) {
                    List<String> fullyQualifiedDomainNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspAccessRuleProperties.fullyQualifiedDomainNames = fullyQualifiedDomainNames;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspAccessRuleProperties;
        });
    }
}

