/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.JsonWebKeyCurveName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.JsonWebKeyOperation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.JsonWebKeyType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsmKeyAttributes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsmKeyReleasePolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsmRotationPolicy;
import java.io.IOException;
import java.util.List;

public final class ManagedHsmKeyProperties
implements JsonSerializable<ManagedHsmKeyProperties> {
    private ManagedHsmKeyAttributes attributes;
    private JsonWebKeyType kty;
    private List<JsonWebKeyOperation> keyOps;
    private Integer keySize;
    private JsonWebKeyCurveName curveName;
    private String keyUri;
    private String keyUriWithVersion;
    private ManagedHsmRotationPolicy rotationPolicy;
    private ManagedHsmKeyReleasePolicy releasePolicy;

    public ManagedHsmKeyAttributes attributes() {
        return this.attributes;
    }

    public ManagedHsmKeyProperties withAttributes(ManagedHsmKeyAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public JsonWebKeyType kty() {
        return this.kty;
    }

    public ManagedHsmKeyProperties withKty(JsonWebKeyType kty) {
        this.kty = kty;
        return this;
    }

    public List<JsonWebKeyOperation> keyOps() {
        return this.keyOps;
    }

    public ManagedHsmKeyProperties withKeyOps(List<JsonWebKeyOperation> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public Integer keySize() {
        return this.keySize;
    }

    public ManagedHsmKeyProperties withKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    public JsonWebKeyCurveName curveName() {
        return this.curveName;
    }

    public ManagedHsmKeyProperties withCurveName(JsonWebKeyCurveName curveName) {
        this.curveName = curveName;
        return this;
    }

    public String keyUri() {
        return this.keyUri;
    }

    public String keyUriWithVersion() {
        return this.keyUriWithVersion;
    }

    public ManagedHsmRotationPolicy rotationPolicy() {
        return this.rotationPolicy;
    }

    public ManagedHsmKeyProperties withRotationPolicy(ManagedHsmRotationPolicy rotationPolicy) {
        this.rotationPolicy = rotationPolicy;
        return this;
    }

    public ManagedHsmKeyReleasePolicy releasePolicy() {
        return this.releasePolicy;
    }

    public ManagedHsmKeyProperties withReleasePolicy(ManagedHsmKeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    public void validate() {
        if (this.attributes() != null) {
            this.attributes().validate();
        }
        if (this.rotationPolicy() != null) {
            this.rotationPolicy().validate();
        }
        if (this.releasePolicy() != null) {
            this.releasePolicy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeStringField("kty", this.kty == null ? null : this.kty.toString());
        jsonWriter.writeArrayField("keyOps", this.keyOps, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeNumberField("keySize", this.keySize);
        jsonWriter.writeStringField("curveName", this.curveName == null ? null : this.curveName.toString());
        jsonWriter.writeJsonField("rotationPolicy", this.rotationPolicy);
        jsonWriter.writeJsonField("release_policy", this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    public static ManagedHsmKeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedHsmKeyProperties deserializedManagedHsmKeyProperties = new ManagedHsmKeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("attributes".equals(fieldName)) {
                    deserializedManagedHsmKeyProperties.attributes = ManagedHsmKeyAttributes.fromJson(reader);
                    continue;
                }
                if ("kty".equals(fieldName)) {
                    deserializedManagedHsmKeyProperties.kty = JsonWebKeyType.fromString(reader.getString());
                    continue;
                }
                if ("keyOps".equals(fieldName)) {
                    List<JsonWebKeyOperation> keyOps = reader.readArray(reader1 -> JsonWebKeyOperation.fromString(reader1.getString()));
                    deserializedManagedHsmKeyProperties.keyOps = keyOps;
                    continue;
                }
                if ("keySize".equals(fieldName)) {
                    deserializedManagedHsmKeyProperties.keySize = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("curveName".equals(fieldName)) {
                    deserializedManagedHsmKeyProperties.curveName = JsonWebKeyCurveName.fromString(reader.getString());
                    continue;
                }
                if ("keyUri".equals(fieldName)) {
                    deserializedManagedHsmKeyProperties.keyUri = reader.getString();
                    continue;
                }
                if ("keyUriWithVersion".equals(fieldName)) {
                    deserializedManagedHsmKeyProperties.keyUriWithVersion = reader.getString();
                    continue;
                }
                if ("rotationPolicy".equals(fieldName)) {
                    deserializedManagedHsmKeyProperties.rotationPolicy = ManagedHsmRotationPolicy.fromJson(reader);
                    continue;
                }
                if ("release_policy".equals(fieldName)) {
                    deserializedManagedHsmKeyProperties.releasePolicy = ManagedHsmKeyReleasePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedHsmKeyProperties;
        });
    }
}

