/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.SecretProperties;
import java.io.IOException;
import java.util.Map;

public final class SecretInner
extends Resource {
    private SecretProperties properties;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(SecretInner.class);

    public SecretProperties properties() {
        return this.properties;
    }

    public SecretInner withProperties(SecretProperties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public SecretInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public SecretInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property properties in model SecretInner"));
        }
        this.properties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    public static SecretInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretInner deserializedSecretInner = new SecretInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSecretInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSecretInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSecretInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSecretInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSecretInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSecretInner.properties = SecretProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretInner;
        });
    }
}

