/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Permissions;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class AccessPolicyEntry
implements JsonSerializable<AccessPolicyEntry> {
    private UUID tenantId;
    private String objectId;
    private UUID applicationId;
    private Permissions permissions;
    private static final ClientLogger LOGGER = new ClientLogger(AccessPolicyEntry.class);

    public UUID tenantId() {
        return this.tenantId;
    }

    public AccessPolicyEntry withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String objectId() {
        return this.objectId;
    }

    public AccessPolicyEntry withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    public UUID applicationId() {
        return this.applicationId;
    }

    public AccessPolicyEntry withApplicationId(UUID applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public Permissions permissions() {
        return this.permissions;
    }

    public AccessPolicyEntry withPermissions(Permissions permissions) {
        this.permissions = permissions;
        return this;
    }

    public void validate() {
        if (this.tenantId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property tenantId in model AccessPolicyEntry"));
        }
        if (this.objectId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property objectId in model AccessPolicyEntry"));
        }
        if (this.permissions() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property permissions in model AccessPolicyEntry"));
        }
        this.permissions().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tenantId", Objects.toString(this.tenantId, null));
        jsonWriter.writeStringField("objectId", this.objectId);
        jsonWriter.writeJsonField("permissions", this.permissions);
        jsonWriter.writeStringField("applicationId", Objects.toString(this.applicationId, null));
        return jsonWriter.writeEndObject();
    }

    public static AccessPolicyEntry fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessPolicyEntry deserializedAccessPolicyEntry = new AccessPolicyEntry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tenantId".equals(fieldName)) {
                    deserializedAccessPolicyEntry.tenantId = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("objectId".equals(fieldName)) {
                    deserializedAccessPolicyEntry.objectId = reader.getString();
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    deserializedAccessPolicyEntry.permissions = Permissions.fromJson(reader);
                    continue;
                }
                if ("applicationId".equals(fieldName)) {
                    deserializedAccessPolicyEntry.applicationId = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccessPolicyEntry;
        });
    }
}

