/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class Attributes
implements JsonSerializable<Attributes> {
    private Boolean enabled;
    private Long notBefore;
    private Long expires;
    private Long created;
    private Long updated;

    public Boolean enabled() {
        return this.enabled;
    }

    public Attributes withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime notBefore() {
        if (this.notBefore == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.notBefore), ZoneOffset.UTC);
    }

    public Attributes withNotBefore(OffsetDateTime notBefore) {
        this.notBefore = notBefore == null ? null : Long.valueOf(notBefore.toEpochSecond());
        return this;
    }

    public OffsetDateTime expires() {
        if (this.expires == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expires), ZoneOffset.UTC);
    }

    public Attributes withExpires(OffsetDateTime expires) {
        this.expires = expires == null ? null : Long.valueOf(expires.toEpochSecond());
        return this;
    }

    public OffsetDateTime created() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    Attributes withCreated(OffsetDateTime created) {
        this.created = created == null ? null : Long.valueOf(created.toEpochSecond());
        return this;
    }

    public OffsetDateTime updated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    Attributes withUpdated(OffsetDateTime updated) {
        this.updated = updated == null ? null : Long.valueOf(updated.toEpochSecond());
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("nbf", this.notBefore);
        jsonWriter.writeNumberField("exp", this.expires);
        return jsonWriter.writeEndObject();
    }

    public static Attributes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Attributes deserializedAttributes = new Attributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedAttributes.enabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("nbf".equals(fieldName)) {
                    deserializedAttributes.notBefore = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("exp".equals(fieldName)) {
                    deserializedAttributes.expires = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedAttributes.created = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedAttributes.updated = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAttributes;
        });
    }
}

