/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.IpRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.NetworkRuleAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.NetworkRuleBypassOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.VirtualNetworkRule;
import java.io.IOException;
import java.util.List;

public final class NetworkRuleSet
implements JsonSerializable<NetworkRuleSet> {
    private NetworkRuleBypassOptions bypass;
    private NetworkRuleAction defaultAction;
    private List<IpRule> ipRules;
    private List<VirtualNetworkRule> virtualNetworkRules;

    public NetworkRuleBypassOptions bypass() {
        return this.bypass;
    }

    public NetworkRuleSet withBypass(NetworkRuleBypassOptions bypass) {
        this.bypass = bypass;
        return this;
    }

    public NetworkRuleAction defaultAction() {
        return this.defaultAction;
    }

    public NetworkRuleSet withDefaultAction(NetworkRuleAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    public List<IpRule> ipRules() {
        return this.ipRules;
    }

    public NetworkRuleSet withIpRules(List<IpRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public NetworkRuleSet withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public void validate() {
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("bypass", this.bypass == null ? null : this.bypass.toString());
        jsonWriter.writeStringField("defaultAction", this.defaultAction == null ? null : this.defaultAction.toString());
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("virtualNetworkRules", this.virtualNetworkRules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkRuleSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkRuleSet deserializedNetworkRuleSet = new NetworkRuleSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bypass".equals(fieldName)) {
                    deserializedNetworkRuleSet.bypass = NetworkRuleBypassOptions.fromString(reader.getString());
                    continue;
                }
                if ("defaultAction".equals(fieldName)) {
                    deserializedNetworkRuleSet.defaultAction = NetworkRuleAction.fromString(reader.getString());
                    continue;
                }
                if ("ipRules".equals(fieldName)) {
                    List<IpRule> ipRules = reader.readArray(reader1 -> IpRule.fromJson(reader1));
                    deserializedNetworkRuleSet.ipRules = ipRules;
                    continue;
                }
                if ("virtualNetworkRules".equals(fieldName)) {
                    List<VirtualNetworkRule> virtualNetworkRules = reader.readArray(reader1 -> VirtualNetworkRule.fromJson(reader1));
                    deserializedNetworkRuleSet.virtualNetworkRules = virtualNetworkRules;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkRuleSet;
        });
    }
}

