/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.RuleAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.RuleCondition;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class AlertRule
implements JsonSerializable<AlertRule> {
    private String name;
    private String description;
    private String provisioningState;
    private boolean isEnabled;
    private RuleCondition condition;
    private RuleAction action;
    private List<RuleAction> actions;
    private OffsetDateTime lastUpdatedTime;
    private static final ClientLogger LOGGER = new ClientLogger(AlertRule.class);

    public String name() {
        return this.name;
    }

    public AlertRule withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public AlertRule withDescription(String description) {
        this.description = description;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public AlertRule withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public AlertRule withIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public RuleCondition condition() {
        return this.condition;
    }

    public AlertRule withCondition(RuleCondition condition) {
        this.condition = condition;
        return this;
    }

    public RuleAction action() {
        return this.action;
    }

    public AlertRule withAction(RuleAction action) {
        this.action = action;
        return this;
    }

    public List<RuleAction> actions() {
        return this.actions;
    }

    public AlertRule withActions(List<RuleAction> actions) {
        this.actions = actions;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model AlertRule"));
        }
        if (this.condition() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property condition in model AlertRule"));
        }
        this.condition().validate();
        if (this.action() != null) {
            this.action().validate();
        }
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeJsonField("condition", this.condition);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("provisioningState", this.provisioningState);
        jsonWriter.writeJsonField("action", this.action);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static AlertRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AlertRule deserializedAlertRule = new AlertRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAlertRule.name = reader.getString();
                    continue;
                }
                if ("isEnabled".equals(fieldName)) {
                    deserializedAlertRule.isEnabled = reader.getBoolean();
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedAlertRule.condition = RuleCondition.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAlertRule.description = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAlertRule.provisioningState = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedAlertRule.action = RuleAction.fromJson(reader);
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List<RuleAction> actions = reader.readArray(reader1 -> RuleAction.fromJson(reader1));
                    deserializedAlertRule.actions = actions;
                    continue;
                }
                if ("lastUpdatedTime".equals(fieldName)) {
                    deserializedAlertRule.lastUpdatedTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAlertRule;
        });
    }
}

