/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.MonitorManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.DiagnosticSettingsOperationsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.MonitorClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.DiagnosticSettingsCategoryResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.DiagnosticSettingsResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation.DiagnosticSettingImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation.DiagnosticSettingsCategoryImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DiagnosticSetting;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DiagnosticSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DiagnosticSettingsCategory;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.exception.AggregatedManagementException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DiagnosticSettingsImpl
extends CreatableResourcesImpl<DiagnosticSetting, DiagnosticSettingImpl, DiagnosticSettingsResourceInner>
implements DiagnosticSettings {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final MonitorManager manager;

    public DiagnosticSettingsImpl(MonitorManager manager) {
        this.manager = manager;
    }

    @Override
    public DiagnosticSettingImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    protected DiagnosticSettingImpl wrapModel(String name) {
        DiagnosticSettingsResourceInner inner = new DiagnosticSettingsResourceInner();
        return new DiagnosticSettingImpl(name, inner, this.manager());
    }

    @Override
    protected DiagnosticSettingImpl wrapModel(DiagnosticSettingsResourceInner inner) {
        if (inner == null) {
            return null;
        }
        return new DiagnosticSettingImpl(inner.name(), inner, this.manager());
    }

    @Override
    public MonitorManager manager() {
        return this.manager;
    }

    public DiagnosticSettingsOperationsClient inner() {
        return ((MonitorClient)this.manager().serviceClient()).getDiagnosticSettingsOperations();
    }

    @Override
    public List<DiagnosticSettingsCategory> listCategoriesByResource(String resourceId) {
        ArrayList<DiagnosticSettingsCategory> categories = new ArrayList<DiagnosticSettingsCategory>();
        PagedIterable<DiagnosticSettingsCategoryResourceInner> collection = ((MonitorClient)this.manager().serviceClient()).getDiagnosticSettingsCategories().list(ResourceUtils.encodeResourceId(resourceId));
        if (collection != null) {
            for (DiagnosticSettingsCategoryResourceInner category : collection) {
                categories.add(new DiagnosticSettingsCategoryImpl(category));
            }
        }
        return categories;
    }

    @Override
    public PagedFlux<DiagnosticSettingsCategory> listCategoriesByResourceAsync(String resourceId) {
        return PagedConverter.mapPage(((MonitorClient)this.manager.serviceClient()).getDiagnosticSettingsCategories().listAsync(ResourceUtils.encodeResourceId(resourceId)), DiagnosticSettingsCategoryImpl::new);
    }

    @Override
    public DiagnosticSettingsCategory getCategory(String resourceId, String name) {
        return new DiagnosticSettingsCategoryImpl(((MonitorClient)this.manager().serviceClient()).getDiagnosticSettingsCategories().get(ResourceUtils.encodeResourceId(resourceId), name));
    }

    @Override
    public Mono<DiagnosticSettingsCategory> getCategoryAsync(String resourceId, String name) {
        return ((MonitorClient)this.manager().serviceClient()).getDiagnosticSettingsCategories().getAsync(ResourceUtils.encodeResourceId(resourceId), name).map(DiagnosticSettingsCategoryImpl::new);
    }

    @Override
    public PagedIterable<DiagnosticSetting> listByResource(String resourceId) {
        return new PagedIterable<DiagnosticSetting>(this.listByResourceAsync(resourceId));
    }

    @Override
    public PagedFlux<DiagnosticSetting> listByResourceAsync(String resourceId) {
        return PagedConverter.mapPage(((MonitorClient)this.manager().serviceClient()).getDiagnosticSettingsOperations().listAsync(ResourceUtils.encodeResourceId(resourceId)), inner -> new DiagnosticSettingImpl(inner.name(), (DiagnosticSettingsResourceInner)inner, this.manager));
    }

    @Override
    public void delete(String resourceId, String name) {
        ((MonitorClient)this.manager().serviceClient()).getDiagnosticSettingsOperations().delete(ResourceUtils.encodeResourceId(resourceId), name);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceId, String name) {
        return ((MonitorClient)this.manager().serviceClient()).getDiagnosticSettingsOperations().deleteAsync(ResourceUtils.encodeResourceId(resourceId), name);
    }

    @Override
    public DiagnosticSetting get(String resourceId, String name) {
        return this.wrapModel(((MonitorClient)this.manager().serviceClient()).getDiagnosticSettingsOperations().get(ResourceUtils.encodeResourceId(resourceId), name));
    }

    @Override
    public Mono<DiagnosticSetting> getAsync(String resourceId, String name) {
        return ((MonitorClient)this.manager().serviceClient()).getDiagnosticSettingsOperations().getAsync(ResourceUtils.encodeResourceId(resourceId), name).map(this::wrapModel);
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        return ((MonitorClient)this.manager().serviceClient()).getDiagnosticSettingsOperations().deleteAsync(this.getResourceIdFromSettingsId(id), this.getNameFromSettingsId(id));
    }

    @Override
    public Flux<String> deleteByIdsAsync(Collection<String> ids) {
        if (CoreUtils.isNullOrEmpty(ids)) {
            return Flux.empty();
        }
        return Flux.fromIterable(ids).flatMapDelayError(id -> this.deleteAsync(this.getResourceIdFromSettingsId((String)id), this.getNameFromSettingsId((String)id)).then(Mono.just(id)), 32, 32).onErrorMap(AggregatedManagementException::convertToManagementException).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler());
    }

    @Override
    public Flux<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    @Override
    public void deleteByIds(Collection<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.deleteByIdsAsync(ids).blockLast();
        }
    }

    @Override
    public void deleteByIds(String ... ids) {
        this.deleteByIds(new ArrayList<String>(Arrays.asList(ids)));
    }

    @Override
    public DiagnosticSetting getById(String id) {
        return this.wrapModel(this.inner().get(this.getResourceIdFromSettingsId(id), this.getNameFromSettingsId(id)));
    }

    @Override
    public Mono<DiagnosticSetting> getByIdAsync(String id) {
        return this.inner().getAsync(this.getResourceIdFromSettingsId(id), this.getNameFromSettingsId(id)).map(this::wrapModel);
    }

    private String getResourceIdFromSettingsId(String diagnosticSettingId) {
        return this.getResourceIdFromSettingsId(diagnosticSettingId, true);
    }

    private String getResourceIdFromSettingsId(String diagnosticSettingId, boolean encodeResourceId) {
        int dsIdx;
        if (diagnosticSettingId == null) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Parameter 'resourceId' is required and cannot be null."));
        }
        if (encodeResourceId) {
            diagnosticSettingId = ResourceUtils.encodeResourceId(diagnosticSettingId);
        }
        if ((dsIdx = diagnosticSettingId.lastIndexOf("/providers/microsoft.insights/diagnosticSettings/")) == -1) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Parameter 'resourceId' does not represent a valid Diagnostic Settings resource Id [" + diagnosticSettingId + "]."));
        }
        return diagnosticSettingId.substring(0, dsIdx);
    }

    private String getNameFromSettingsId(String diagnosticSettingId) {
        String resourceId = this.getResourceIdFromSettingsId(diagnosticSettingId, false);
        return diagnosticSettingId.substring(resourceId.length() + "/providers/microsoft.insights/diagnosticSettings/".length());
    }
}

