/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DataCollectionRuleDataSources;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DataCollectionRuleDestinations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DataCollectionRuleMetadata;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DataFlow;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.KnownDataCollectionRuleProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.StreamDeclaration;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DataCollectionRule
implements JsonSerializable<DataCollectionRule> {
    private String description;
    private String immutableId;
    private String dataCollectionEndpointId;
    private DataCollectionRuleMetadata metadata;
    private Map<String, StreamDeclaration> streamDeclarations;
    private DataCollectionRuleDataSources dataSources;
    private DataCollectionRuleDestinations destinations;
    private List<DataFlow> dataFlows;
    private KnownDataCollectionRuleProvisioningState provisioningState;

    public String description() {
        return this.description;
    }

    public DataCollectionRule withDescription(String description) {
        this.description = description;
        return this;
    }

    public String immutableId() {
        return this.immutableId;
    }

    DataCollectionRule withImmutableId(String immutableId) {
        this.immutableId = immutableId;
        return this;
    }

    public String dataCollectionEndpointId() {
        return this.dataCollectionEndpointId;
    }

    public DataCollectionRule withDataCollectionEndpointId(String dataCollectionEndpointId) {
        this.dataCollectionEndpointId = dataCollectionEndpointId;
        return this;
    }

    public DataCollectionRuleMetadata metadata() {
        return this.metadata;
    }

    DataCollectionRule withMetadata(DataCollectionRuleMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, StreamDeclaration> streamDeclarations() {
        return this.streamDeclarations;
    }

    public DataCollectionRule withStreamDeclarations(Map<String, StreamDeclaration> streamDeclarations) {
        this.streamDeclarations = streamDeclarations;
        return this;
    }

    public DataCollectionRuleDataSources dataSources() {
        return this.dataSources;
    }

    public DataCollectionRule withDataSources(DataCollectionRuleDataSources dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    public DataCollectionRuleDestinations destinations() {
        return this.destinations;
    }

    public DataCollectionRule withDestinations(DataCollectionRuleDestinations destinations) {
        this.destinations = destinations;
        return this;
    }

    public List<DataFlow> dataFlows() {
        return this.dataFlows;
    }

    public DataCollectionRule withDataFlows(List<DataFlow> dataFlows) {
        this.dataFlows = dataFlows;
        return this;
    }

    public KnownDataCollectionRuleProvisioningState provisioningState() {
        return this.provisioningState;
    }

    DataCollectionRule withProvisioningState(KnownDataCollectionRuleProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public void validate() {
        if (this.metadata() != null) {
            this.metadata().validate();
        }
        if (this.streamDeclarations() != null) {
            this.streamDeclarations().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.dataSources() != null) {
            this.dataSources().validate();
        }
        if (this.destinations() != null) {
            this.destinations().validate();
        }
        if (this.dataFlows() != null) {
            this.dataFlows().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("dataCollectionEndpointId", this.dataCollectionEndpointId);
        jsonWriter.writeMapField("streamDeclarations", this.streamDeclarations, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("dataSources", this.dataSources);
        jsonWriter.writeJsonField("destinations", this.destinations);
        jsonWriter.writeArrayField("dataFlows", this.dataFlows, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static DataCollectionRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataCollectionRule deserializedDataCollectionRule = new DataCollectionRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedDataCollectionRule.description = reader.getString();
                    continue;
                }
                if ("immutableId".equals(fieldName)) {
                    deserializedDataCollectionRule.immutableId = reader.getString();
                    continue;
                }
                if ("dataCollectionEndpointId".equals(fieldName)) {
                    deserializedDataCollectionRule.dataCollectionEndpointId = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedDataCollectionRule.metadata = DataCollectionRuleMetadata.fromJson(reader);
                    continue;
                }
                if ("streamDeclarations".equals(fieldName)) {
                    Map<String, StreamDeclaration> streamDeclarations = reader.readMap(reader1 -> StreamDeclaration.fromJson(reader1));
                    deserializedDataCollectionRule.streamDeclarations = streamDeclarations;
                    continue;
                }
                if ("dataSources".equals(fieldName)) {
                    deserializedDataCollectionRule.dataSources = DataCollectionRuleDataSources.fromJson(reader);
                    continue;
                }
                if ("destinations".equals(fieldName)) {
                    deserializedDataCollectionRule.destinations = DataCollectionRuleDestinations.fromJson(reader);
                    continue;
                }
                if ("dataFlows".equals(fieldName)) {
                    List<DataFlow> dataFlows = reader.readArray(reader1 -> DataFlow.fromJson(reader1));
                    deserializedDataCollectionRule.dataFlows = dataFlows;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDataCollectionRule.provisioningState = KnownDataCollectionRuleProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataCollectionRule;
        });
    }
}

