/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.ReceiverStatus;
import java.io.IOException;

public final class EmailReceiver
implements JsonSerializable<EmailReceiver> {
    private String name;
    private String emailAddress;
    private Boolean useCommonAlertSchema;
    private ReceiverStatus status;
    private static final ClientLogger LOGGER = new ClientLogger(EmailReceiver.class);

    public String name() {
        return this.name;
    }

    public EmailReceiver withName(String name) {
        this.name = name;
        return this;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public EmailReceiver withEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    public Boolean useCommonAlertSchema() {
        return this.useCommonAlertSchema;
    }

    public EmailReceiver withUseCommonAlertSchema(Boolean useCommonAlertSchema) {
        this.useCommonAlertSchema = useCommonAlertSchema;
        return this;
    }

    public ReceiverStatus status() {
        return this.status;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model EmailReceiver"));
        }
        if (this.emailAddress() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property emailAddress in model EmailReceiver"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("emailAddress", this.emailAddress);
        jsonWriter.writeBooleanField("useCommonAlertSchema", this.useCommonAlertSchema);
        return jsonWriter.writeEndObject();
    }

    public static EmailReceiver fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EmailReceiver deserializedEmailReceiver = new EmailReceiver();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedEmailReceiver.name = reader.getString();
                    continue;
                }
                if ("emailAddress".equals(fieldName)) {
                    deserializedEmailReceiver.emailAddress = reader.getString();
                    continue;
                }
                if ("useCommonAlertSchema".equals(fieldName)) {
                    deserializedEmailReceiver.useCommonAlertSchema = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedEmailReceiver.status = ReceiverStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEmailReceiver;
        });
    }
}

