/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class MetricValue
implements JsonSerializable<MetricValue> {
    private OffsetDateTime timestamp;
    private Double average;
    private Double minimum;
    private Double maximum;
    private Double total;
    private Double count;
    private static final ClientLogger LOGGER = new ClientLogger(MetricValue.class);

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public MetricValue withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Double average() {
        return this.average;
    }

    public MetricValue withAverage(Double average) {
        this.average = average;
        return this;
    }

    public Double minimum() {
        return this.minimum;
    }

    public MetricValue withMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    public Double maximum() {
        return this.maximum;
    }

    public MetricValue withMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public Double total() {
        return this.total;
    }

    public MetricValue withTotal(Double total) {
        this.total = total;
        return this;
    }

    public Double count() {
        return this.count;
    }

    public MetricValue withCount(Double count) {
        this.count = count;
        return this;
    }

    public void validate() {
        if (this.timestamp() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property timestamp in model MetricValue"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeStamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeNumberField("average", this.average);
        jsonWriter.writeNumberField("minimum", this.minimum);
        jsonWriter.writeNumberField("maximum", this.maximum);
        jsonWriter.writeNumberField("total", this.total);
        jsonWriter.writeNumberField("count", this.count);
        return jsonWriter.writeEndObject();
    }

    public static MetricValue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricValue deserializedMetricValue = new MetricValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeStamp".equals(fieldName)) {
                    deserializedMetricValue.timestamp = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("average".equals(fieldName)) {
                    deserializedMetricValue.average = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("minimum".equals(fieldName)) {
                    deserializedMetricValue.minimum = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("maximum".equals(fieldName)) {
                    deserializedMetricValue.maximum = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("total".equals(fieldName)) {
                    deserializedMetricValue.total = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedMetricValue.count = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricValue;
        });
    }
}

