/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.RecurrenceFrequency;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.RecurrentSchedule;
import java.io.IOException;

public final class Recurrence
implements JsonSerializable<Recurrence> {
    private RecurrenceFrequency frequency;
    private RecurrentSchedule schedule;
    private static final ClientLogger LOGGER = new ClientLogger(Recurrence.class);

    public RecurrenceFrequency frequency() {
        return this.frequency;
    }

    public Recurrence withFrequency(RecurrenceFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public RecurrentSchedule schedule() {
        return this.schedule;
    }

    public Recurrence withSchedule(RecurrentSchedule schedule2) {
        this.schedule = schedule2;
        return this;
    }

    public void validate() {
        if (this.frequency() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property frequency in model Recurrence"));
        }
        if (this.schedule() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property schedule in model Recurrence"));
        }
        this.schedule().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("frequency", this.frequency == null ? null : this.frequency.toString());
        jsonWriter.writeJsonField("schedule", this.schedule);
        return jsonWriter.writeEndObject();
    }

    public static Recurrence fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Recurrence deserializedRecurrence = new Recurrence();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("frequency".equals(fieldName)) {
                    deserializedRecurrence.frequency = RecurrenceFrequency.fromString(reader.getString());
                    continue;
                }
                if ("schedule".equals(fieldName)) {
                    deserializedRecurrence.schedule = RecurrentSchedule.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecurrence;
        });
    }
}

