/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRoutePortsLocationPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRoutePortsLocationBandwidths;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ExpressRoutePortsLocationInner
extends Resource {
    private ExpressRoutePortsLocationPropertiesFormat innerProperties;
    private String id;
    private String type;
    private String name;

    private ExpressRoutePortsLocationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    public ExpressRoutePortsLocationInner withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ExpressRoutePortsLocationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public ExpressRoutePortsLocationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String address() {
        return this.innerProperties() == null ? null : this.innerProperties().address();
    }

    public String contact() {
        return this.innerProperties() == null ? null : this.innerProperties().contact();
    }

    public List<ExpressRoutePortsLocationBandwidths> availableBandwidths() {
        return this.innerProperties() == null ? null : this.innerProperties().availableBandwidths();
    }

    public ExpressRoutePortsLocationInner withAvailableBandwidths(List<ExpressRoutePortsLocationBandwidths> availableBandwidths) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRoutePortsLocationPropertiesFormat();
        }
        this.innerProperties().withAvailableBandwidths(availableBandwidths);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRoutePortsLocationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRoutePortsLocationInner deserializedExpressRoutePortsLocationInner = new ExpressRoutePortsLocationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedExpressRoutePortsLocationInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationInner.innerProperties = ExpressRoutePortsLocationPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRoutePortsLocationInner;
        });
    }
}

