/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.BackendAddressPoolInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.InboundNatRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.LoadBalancerPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.LoadBalancingRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.OutboundRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ProbeInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExtendedLocation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.InboundNatPool;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class LoadBalancerInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private LoadBalancerSku sku;
    private LoadBalancerPropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public LoadBalancerInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public LoadBalancerSku sku() {
        return this.sku;
    }

    public LoadBalancerInner withSku(LoadBalancerSku sku) {
        this.sku = sku;
        return this;
    }

    private LoadBalancerPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public String id() {
        return this.id;
    }

    public LoadBalancerInner withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public LoadBalancerInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public LoadBalancerInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<FrontendIpConfigurationInner> frontendIpConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendIpConfigurations();
    }

    public LoadBalancerInner withFrontendIpConfigurations(List<FrontendIpConfigurationInner> frontendIpConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withFrontendIpConfigurations(frontendIpConfigurations);
        return this;
    }

    public List<BackendAddressPoolInner> backendAddressPools() {
        return this.innerProperties() == null ? null : this.innerProperties().backendAddressPools();
    }

    public LoadBalancerInner withBackendAddressPools(List<BackendAddressPoolInner> backendAddressPools) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withBackendAddressPools(backendAddressPools);
        return this;
    }

    public List<LoadBalancingRuleInner> loadBalancingRules() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancingRules();
    }

    public LoadBalancerInner withLoadBalancingRules(List<LoadBalancingRuleInner> loadBalancingRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withLoadBalancingRules(loadBalancingRules);
        return this;
    }

    public List<ProbeInner> probes() {
        return this.innerProperties() == null ? null : this.innerProperties().probes();
    }

    public LoadBalancerInner withProbes(List<ProbeInner> probes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withProbes(probes);
        return this;
    }

    public List<InboundNatRuleInner> inboundNatRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundNatRules();
    }

    public LoadBalancerInner withInboundNatRules(List<InboundNatRuleInner> inboundNatRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withInboundNatRules(inboundNatRules);
        return this;
    }

    public List<InboundNatPool> inboundNatPools() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundNatPools();
    }

    public LoadBalancerInner withInboundNatPools(List<InboundNatPool> inboundNatPools) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withInboundNatPools(inboundNatPools);
        return this;
    }

    public List<OutboundRuleInner> outboundRules() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundRules();
    }

    public LoadBalancerInner withOutboundRules(List<OutboundRuleInner> outboundRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerPropertiesFormat();
        }
        this.innerProperties().withOutboundRules(outboundRules);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("extendedLocation", this.extendedLocation);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static LoadBalancerInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoadBalancerInner deserializedLoadBalancerInner = new LoadBalancerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedLoadBalancerInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLoadBalancerInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedLoadBalancerInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedLoadBalancerInner.withTags((Map)tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedLoadBalancerInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedLoadBalancerInner.sku = LoadBalancerSku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLoadBalancerInner.innerProperties = LoadBalancerPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedLoadBalancerInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedLoadBalancerInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoadBalancerInner;
        });
    }
}

