/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NatGatewayPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NatGatewaySku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class NatGatewayInner
extends Resource {
    private NatGatewaySku sku;
    private NatGatewayPropertiesFormat innerProperties;
    private List<String> zones;
    private String etag;
    private String id;
    private String type;
    private String name;

    public NatGatewaySku sku() {
        return this.sku;
    }

    public NatGatewayInner withSku(NatGatewaySku sku) {
        this.sku = sku;
        return this;
    }

    private NatGatewayPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public NatGatewayInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public String id() {
        return this.id;
    }

    public NatGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public NatGatewayInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public NatGatewayInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().idleTimeoutInMinutes();
    }

    public NatGatewayInner withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NatGatewayPropertiesFormat();
        }
        this.innerProperties().withIdleTimeoutInMinutes(idleTimeoutInMinutes);
        return this;
    }

    public List<SubResource> publicIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddresses();
    }

    public NatGatewayInner withPublicIpAddresses(List<SubResource> publicIpAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NatGatewayPropertiesFormat();
        }
        this.innerProperties().withPublicIpAddresses(publicIpAddresses);
        return this;
    }

    public List<SubResource> publicIpPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpPrefixes();
    }

    public NatGatewayInner withPublicIpPrefixes(List<SubResource> publicIpPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NatGatewayPropertiesFormat();
        }
        this.innerProperties().withPublicIpPrefixes(publicIpPrefixes);
        return this;
    }

    public List<SubResource> subnets() {
        return this.innerProperties() == null ? null : this.innerProperties().subnets();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static NatGatewayInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NatGatewayInner deserializedNatGatewayInner = new NatGatewayInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNatGatewayInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNatGatewayInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedNatGatewayInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedNatGatewayInner.withTags((Map)tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedNatGatewayInner.sku = NatGatewaySku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNatGatewayInner.innerProperties = NatGatewayPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedNatGatewayInner.zones = zones;
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedNatGatewayInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedNatGatewayInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNatGatewayInner;
        });
    }
}

