/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VirtualRouterPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualRouterInner
extends Resource {
    private VirtualRouterPropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private VirtualRouterPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public String id() {
        return this.id;
    }

    public VirtualRouterInner withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public VirtualRouterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public VirtualRouterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Long virtualRouterAsn() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualRouterAsn();
    }

    public VirtualRouterInner withVirtualRouterAsn(Long virtualRouterAsn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualRouterPropertiesFormat();
        }
        this.innerProperties().withVirtualRouterAsn(virtualRouterAsn);
        return this;
    }

    public List<String> virtualRouterIps() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualRouterIps();
    }

    public VirtualRouterInner withVirtualRouterIps(List<String> virtualRouterIps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualRouterPropertiesFormat();
        }
        this.innerProperties().withVirtualRouterIps(virtualRouterIps);
        return this;
    }

    public SubResource hostedSubnet() {
        return this.innerProperties() == null ? null : this.innerProperties().hostedSubnet();
    }

    public VirtualRouterInner withHostedSubnet(SubResource hostedSubnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualRouterPropertiesFormat();
        }
        this.innerProperties().withHostedSubnet(hostedSubnet);
        return this;
    }

    public SubResource hostedGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().hostedGateway();
    }

    public VirtualRouterInner withHostedGateway(SubResource hostedGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualRouterPropertiesFormat();
        }
        this.innerProperties().withHostedGateway(hostedGateway);
        return this;
    }

    public List<SubResource> peerings() {
        return this.innerProperties() == null ? null : this.innerProperties().peerings();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static VirtualRouterInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualRouterInner deserializedVirtualRouterInner = new VirtualRouterInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVirtualRouterInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualRouterInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVirtualRouterInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualRouterInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualRouterInner.innerProperties = VirtualRouterPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVirtualRouterInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVirtualRouterInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualRouterInner;
        });
    }
}

