/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ApplicationGatewaySslCertificateImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayFrontend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayHttpListener;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayListener;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewaySslCertificate;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ApplicationGatewayListenerImpl
extends ChildResourceImpl<ApplicationGatewayHttpListener, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayListener,
ApplicationGatewayListener.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayListener.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayListener.Update {
    ApplicationGatewayListenerImpl(ApplicationGatewayHttpListener inner, ApplicationGatewayImpl parent) {
        super(inner, parent);
    }

    @Override
    public String networkId() {
        ApplicationGatewayFrontend frontend = this.frontend();
        if (frontend != null) {
            return frontend.networkId();
        }
        return null;
    }

    @Override
    public String subnetName() {
        ApplicationGatewayFrontend frontend = this.frontend();
        if (frontend != null) {
            return frontend.subnetName();
        }
        return null;
    }

    @Override
    public boolean requiresServerNameIndication() {
        if (((ApplicationGatewayHttpListener)this.innerModel()).requireServerNameIndication() != null) {
            return ((ApplicationGatewayHttpListener)this.innerModel()).requireServerNameIndication();
        }
        return false;
    }

    @Override
    public String hostname() {
        if (((ApplicationGatewayHttpListener)this.innerModel()).hostname() != null) {
            return ((ApplicationGatewayHttpListener)this.innerModel()).hostname();
        }
        if (!CoreUtils.isNullOrEmpty(((ApplicationGatewayHttpListener)this.innerModel()).hostNames())) {
            return ((ApplicationGatewayHttpListener)this.innerModel()).hostNames().get(0);
        }
        return null;
    }

    @Override
    public List<String> hostnames() {
        if (((ApplicationGatewayHttpListener)this.innerModel()).hostname() != null) {
            return Collections.singletonList(((ApplicationGatewayHttpListener)this.innerModel()).hostname());
        }
        if (CoreUtils.isNullOrEmpty(((ApplicationGatewayHttpListener)this.innerModel()).hostNames())) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(((ApplicationGatewayHttpListener)this.innerModel()).hostNames());
    }

    @Override
    public String publicIpAddressId() {
        ApplicationGatewayFrontend frontend = this.frontend();
        if (frontend == null) {
            return null;
        }
        return frontend.publicIpAddressId();
    }

    @Override
    public PublicIpAddress getPublicIpAddress() {
        return this.getPublicIpAddressAsync().block();
    }

    @Override
    public Mono<PublicIpAddress> getPublicIpAddressAsync() {
        String pipId = this.publicIpAddressId();
        return pipId == null ? Mono.empty() : ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).publicIpAddresses().getByIdAsync(pipId);
    }

    @Override
    public String name() {
        return ((ApplicationGatewayHttpListener)this.innerModel()).name();
    }

    @Override
    public ApplicationGatewaySslCertificate sslCertificate() {
        SubResource certRef = ((ApplicationGatewayHttpListener)this.innerModel()).sslCertificate();
        if (certRef == null) {
            return null;
        }
        String name = ResourceUtils.nameFromResourceId(certRef.id());
        return ((ApplicationGatewayImpl)this.parent()).sslCertificates().get(name);
    }

    @Override
    public ApplicationGatewayProtocol protocol() {
        return ((ApplicationGatewayHttpListener)this.innerModel()).protocol();
    }

    @Override
    public int frontendPortNumber() {
        String name = this.frontendPortName();
        if (name == null) {
            return 0;
        }
        if (!((ApplicationGatewayImpl)this.parent()).frontendPorts().containsKey(name)) {
            return 0;
        }
        return ((ApplicationGatewayImpl)this.parent()).frontendPorts().get(name);
    }

    @Override
    public String frontendPortName() {
        if (((ApplicationGatewayHttpListener)this.innerModel()).frontendPort() != null) {
            return ResourceUtils.nameFromResourceId(((ApplicationGatewayHttpListener)this.innerModel()).frontendPort().id());
        }
        return null;
    }

    @Override
    public ApplicationGatewayFrontend frontend() {
        SubResource frontendInner = ((ApplicationGatewayHttpListener)this.innerModel()).frontendIpConfiguration();
        if (frontendInner == null) {
            return null;
        }
        String frontendName = ResourceUtils.nameFromResourceId(frontendInner.id());
        return ((ApplicationGatewayImpl)this.parent()).frontends().get(frontendName);
    }

    @Override
    public ApplicationGatewayImpl attach() {
        ((ApplicationGatewayImpl)this.parent()).withHttpListener(this);
        return (ApplicationGatewayImpl)this.parent();
    }

    private ApplicationGatewayListenerImpl withFrontend(String name) {
        SubResource frontendRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/frontendIPConfigurations/" + name);
        ((ApplicationGatewayHttpListener)this.innerModel()).withFrontendIpConfiguration(frontendRef);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withFrontendPort(String name) {
        SubResource portRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/frontendPorts/" + name);
        ((ApplicationGatewayHttpListener)this.innerModel()).withFrontendPort(portRef);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withFrontendPort(int portNumber) {
        String portName = ((ApplicationGatewayImpl)this.parent()).frontendPortNameFromNumber(portNumber);
        if (portName == null) {
            portName = ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("port", 9);
            ((ApplicationGatewayImpl)this.parent()).withFrontendPort(portNumber, portName);
        }
        return this.withFrontendPort(portName);
    }

    @Override
    public ApplicationGatewayListenerImpl withSslCertificate(String name) {
        SubResource certRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/sslCertificates/" + name);
        ((ApplicationGatewayHttpListener)this.innerModel()).withSslCertificate(certRef);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withSslCertificateFromKeyVaultSecretId(String keyVaultSecretId) {
        return this.withSslCertificateFromKeyVaultSecretId(keyVaultSecretId, null);
    }

    private ApplicationGatewayListenerImpl withSslCertificateFromKeyVaultSecretId(String keyVaultSecretId, String name) {
        if (name == null) {
            name = ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("cert", 10);
        }
        ((ApplicationGatewayImpl)this.parent()).defineSslCertificate(name).withKeyVaultSecretId(keyVaultSecretId).attach();
        return this;
    }

    public ApplicationGatewayListenerImpl withSslCertificateFromPfxFile(File pfxFile) throws IOException {
        return this.withSslCertificateFromPfxFile(pfxFile, null);
    }

    private ApplicationGatewayListenerImpl withSslCertificateFromPfxFile(File pfxFile, String name) throws IOException {
        if (name == null) {
            name = ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("cert", 10);
        }
        ((ApplicationGatewayImpl)this.parent()).defineSslCertificate(name).withPfxFromFile(pfxFile).attach();
        return this.withSslCertificate(name);
    }

    @Override
    public ApplicationGatewayListenerImpl withSslCertificatePassword(String password) {
        ApplicationGatewaySslCertificateImpl sslCert = (ApplicationGatewaySslCertificateImpl)this.sslCertificate();
        if (sslCert != null) {
            sslCert.withPfxPassword(password);
        }
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHttp() {
        ((ApplicationGatewayHttpListener)this.innerModel()).withProtocol(ApplicationGatewayProtocol.HTTP);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHttps() {
        ((ApplicationGatewayHttpListener)this.innerModel()).withProtocol(ApplicationGatewayProtocol.HTTPS);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHostname(String hostname) {
        if (hostname != null) {
            ((ApplicationGatewayHttpListener)this.innerModel()).withHostname(null);
            ArrayList<String> hostNames = new ArrayList<String>();
            hostNames.add(hostname);
            ((ApplicationGatewayHttpListener)this.innerModel()).withHostNames(hostNames);
        }
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHostnames(List<String> hostnames) {
        if (!CoreUtils.isNullOrEmpty(hostnames)) {
            ((ApplicationGatewayHttpListener)this.innerModel()).withHostname(null);
            ((ApplicationGatewayHttpListener)this.innerModel()).withHostNames(hostnames);
        }
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withServerNameIndication() {
        ((ApplicationGatewayHttpListener)this.innerModel()).withRequireServerNameIndication(true);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withoutServerNameIndication() {
        ((ApplicationGatewayHttpListener)this.innerModel()).withRequireServerNameIndication(false);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withPrivateFrontend() {
        this.withFrontend(((ApplicationGatewayImpl)this.parent()).ensureDefaultPrivateFrontend().name());
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withPublicFrontend() {
        this.withFrontend(((ApplicationGatewayImpl)this.parent()).ensureDefaultPublicFrontend().name());
        return this;
    }
}

