/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ConnectivityInformationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectivityCheck;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectivityDestination;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectivityHop;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectivityParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectivitySource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.HasNetworkInterfaces;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Protocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.ExecutableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.List;

public class ConnectivityCheckImpl
extends ExecutableImpl<ConnectivityCheck>
implements ConnectivityCheck,
ConnectivityCheck.Definition {
    private final NetworkWatcherImpl parent;
    private ConnectivityParameters parameters = new ConnectivityParameters();
    private ConnectivityInformationInner result;

    ConnectivityCheckImpl(NetworkWatcherImpl parent) {
        this.parent = parent;
    }

    @Override
    public ConnectivityCheckImpl fromSourceVirtualMachine(String sourceResourceId) {
        this.ensureConnectivitySource().withResourceId(sourceResourceId);
        return this;
    }

    @Override
    public ConnectivityCheck.DefinitionStages.WithExecute fromSourceVirtualMachine(HasNetworkInterfaces vm) {
        this.ensureConnectivitySource().withResourceId(vm.id());
        return this;
    }

    @Override
    public ConnectivityCheckImpl toDestinationResourceId(String resourceId) {
        this.ensureConnectivityDestination().withResourceId(resourceId);
        return this;
    }

    @Override
    public ConnectivityCheckImpl toDestinationAddress(String address) {
        this.ensureConnectivityDestination().withAddress(address);
        return this;
    }

    @Override
    public ConnectivityCheckImpl toDestinationPort(int port) {
        this.ensureConnectivityDestination().withPort(port);
        return this;
    }

    @Override
    public ConnectivityCheckImpl fromSourcePort(int port) {
        this.ensureConnectivitySource().withPort(port);
        return this;
    }

    @Override
    public ConnectivityCheckImpl withProtocol(Protocol protocol) {
        this.parameters.withProtocol(protocol);
        return this;
    }

    private ConnectivitySource ensureConnectivitySource() {
        if (this.parameters.source() == null) {
            this.parameters.withSource(new ConnectivitySource());
        }
        return this.parameters.source();
    }

    private ConnectivityDestination ensureConnectivityDestination() {
        if (this.parameters.destination() == null) {
            this.parameters.withDestination(new ConnectivityDestination());
        }
        return this.parameters.destination();
    }

    @Override
    public NetworkWatcherImpl parent() {
        return this.parent;
    }

    @Override
    public List<ConnectivityHop> hops() {
        return this.result.hops();
    }

    @Override
    public ConnectionStatus connectionStatus() {
        return this.result.connectionStatus();
    }

    @Override
    public int avgLatencyInMs() {
        return ResourceManagerUtils.toPrimitiveInt(this.result.avgLatencyInMs());
    }

    @Override
    public int minLatencyInMs() {
        return ResourceManagerUtils.toPrimitiveInt(this.result.minLatencyInMs());
    }

    @Override
    public int maxLatencyInMs() {
        return ResourceManagerUtils.toPrimitiveInt(this.result.maxLatencyInMs());
    }

    @Override
    public int probesSent() {
        return ResourceManagerUtils.toPrimitiveInt(this.result.probesSent());
    }

    @Override
    public int probesFailed() {
        return ResourceManagerUtils.toPrimitiveInt(this.result.probesFailed());
    }

    @Override
    public Mono<ConnectivityCheck> executeWorkAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.parent().manager()).serviceClient()).getNetworkWatchers().checkConnectivityAsync(this.parent.resourceGroupName(), this.parent.name(), this.parameters).map(connectivityInformation -> {
            this.result = connectivityInformation;
            return this;
        });
    }
}

