/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitAuthorizationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ExpressRouteCircuitPeeringImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ExpressRouteCircuitPeeringsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCircuit;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCircuitPeering;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCircuitPeerings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCircuitServiceProviderProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCircuitSkuType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ServiceProviderProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.TagsObject;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ExpressRouteCircuitImpl
extends GroupableParentResourceWithTagsImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl, NetworkManager>
implements ExpressRouteCircuit,
ExpressRouteCircuit.Definition,
ExpressRouteCircuit.Update {
    private ExpressRouteCircuitPeeringsImpl peerings;
    private Map<String, ExpressRouteCircuitPeering> expressRouteCircuitPeerings;

    ExpressRouteCircuitImpl(String name, ExpressRouteCircuitInner innerObject, NetworkManager manager) {
        super(name, innerObject, manager);
        this.initializeChildrenFromInner();
    }

    @Override
    public ExpressRouteCircuitImpl withServiceProvider(String serviceProviderName) {
        this.ensureServiceProviderProperties().withServiceProviderName(serviceProviderName);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withPeeringLocation(String location) {
        this.ensureServiceProviderProperties().withPeeringLocation(location);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withBandwidthInMbps(int bandwidthInMbps) {
        this.ensureServiceProviderProperties().withBandwidthInMbps(bandwidthInMbps);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withSku(ExpressRouteCircuitSkuType sku) {
        ((ExpressRouteCircuitInner)this.innerModel()).withSku(sku.sku());
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withClassicOperations() {
        ((ExpressRouteCircuitInner)this.innerModel()).withAllowClassicOperations(true);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withoutClassicOperations() {
        ((ExpressRouteCircuitInner)this.innerModel()).withAllowClassicOperations(false);
        return this;
    }

    @Override
    public ExpressRouteCircuitImpl withAuthorization(String authorizationName) {
        this.ensureAuthorizations().add(new ExpressRouteCircuitAuthorizationInner().withName(authorizationName));
        return this;
    }

    private List<ExpressRouteCircuitAuthorizationInner> ensureAuthorizations() {
        if (((ExpressRouteCircuitInner)this.innerModel()).authorizations() == null) {
            ((ExpressRouteCircuitInner)this.innerModel()).withAuthorizations(new ArrayList<ExpressRouteCircuitAuthorizationInner>());
        }
        return ((ExpressRouteCircuitInner)this.innerModel()).authorizations();
    }

    private ExpressRouteCircuitServiceProviderProperties ensureServiceProviderProperties() {
        if (((ExpressRouteCircuitInner)this.innerModel()).serviceProviderProperties() == null) {
            ((ExpressRouteCircuitInner)this.innerModel()).withServiceProviderProperties(new ExpressRouteCircuitServiceProviderProperties());
        }
        return ((ExpressRouteCircuitInner)this.innerModel()).serviceProviderProperties();
    }

    @Override
    protected Mono<ExpressRouteCircuitInner> createInner() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCircuits().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ExpressRouteCircuitInner)this.innerModel());
    }

    @Override
    protected void initializeChildrenFromInner() {
        this.expressRouteCircuitPeerings = new HashMap<String, ExpressRouteCircuitPeering>();
        if (((ExpressRouteCircuitInner)this.innerModel()).peerings() != null) {
            for (ExpressRouteCircuitPeeringInner peering : ((ExpressRouteCircuitInner)this.innerModel()).peerings()) {
                this.expressRouteCircuitPeerings.put(peering.name(), new ExpressRouteCircuitPeeringImpl(this, peering, ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCircuitPeerings(), peering.peeringType()));
            }
        }
    }

    @Override
    protected Mono<ExpressRouteCircuitInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCircuits().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<ExpressRouteCircuit> refreshAsync() {
        return super.refreshAsync().map(expressRouteCircuit -> {
            ExpressRouteCircuitImpl impl = (ExpressRouteCircuitImpl)expressRouteCircuit;
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    @Override
    protected Mono<ExpressRouteCircuitInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCircuits().updateTagsAsync(this.resourceGroupName(), this.name(), new TagsObject().withTags(((ExpressRouteCircuitInner)this.innerModel()).tags()));
    }

    @Override
    public ExpressRouteCircuitPeerings peerings() {
        if (this.peerings == null) {
            this.peerings = new ExpressRouteCircuitPeeringsImpl(this);
        }
        return this.peerings;
    }

    @Override
    public ExpressRouteCircuitSkuType sku() {
        return ExpressRouteCircuitSkuType.fromSku(((ExpressRouteCircuitInner)this.innerModel()).sku());
    }

    @Override
    public boolean isAllowClassicOperations() {
        return ResourceManagerUtils.toPrimitiveBoolean(((ExpressRouteCircuitInner)this.innerModel()).allowClassicOperations());
    }

    @Override
    public String circuitProvisioningState() {
        return ((ExpressRouteCircuitInner)this.innerModel()).circuitProvisioningState();
    }

    @Override
    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return ((ExpressRouteCircuitInner)this.innerModel()).serviceProviderProvisioningState();
    }

    @Override
    public String serviceKey() {
        return ((ExpressRouteCircuitInner)this.innerModel()).serviceKey();
    }

    @Override
    public String serviceProviderNotes() {
        return ((ExpressRouteCircuitInner)this.innerModel()).serviceProviderNotes();
    }

    @Override
    public ExpressRouteCircuitServiceProviderProperties serviceProviderProperties() {
        return ((ExpressRouteCircuitInner)this.innerModel()).serviceProviderProperties();
    }

    @Override
    public String provisioningState() {
        return ((ExpressRouteCircuitInner)this.innerModel()).provisioningState().toString();
    }

    @Override
    public Map<String, ExpressRouteCircuitPeering> peeringsMap() {
        return this.expressRouteCircuitPeerings;
    }
}

