/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.FirewallPolicyIdpsSignaturesFilterValuesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SignatureOverridesFilterValuesResponseInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SignatureOverridesFilterValuesQuery;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class FirewallPolicyIdpsSignaturesFilterValuesClientImpl
implements FirewallPolicyIdpsSignaturesFilterValuesClient {
    private final FirewallPolicyIdpsSignaturesFilterValuesService service;
    private final NetworkManagementClientImpl client;

    FirewallPolicyIdpsSignaturesFilterValuesClientImpl(NetworkManagementClientImpl client) {
        this.service = RestProxy.create(FirewallPolicyIdpsSignaturesFilterValuesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SignatureOverridesFilterValuesResponseInner>> listWithResponseAsync(String resourceGroupName, String firewallPolicyName, SignatureOverridesFilterValuesQuery parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, this.client.getSubscriptionId(), "2024-05-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SignatureOverridesFilterValuesResponseInner>> listWithResponseAsync(String resourceGroupName, String firewallPolicyName, SignatureOverridesFilterValuesQuery parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, this.client.getSubscriptionId(), "2024-05-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SignatureOverridesFilterValuesResponseInner> listAsync(String resourceGroupName, String firewallPolicyName, SignatureOverridesFilterValuesQuery parameters) {
        return this.listWithResponseAsync(resourceGroupName, firewallPolicyName, parameters).flatMap(res -> Mono.justOrEmpty((SignatureOverridesFilterValuesResponseInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SignatureOverridesFilterValuesResponseInner> listWithResponse(String resourceGroupName, String firewallPolicyName, SignatureOverridesFilterValuesQuery parameters, Context context) {
        return this.listWithResponseAsync(resourceGroupName, firewallPolicyName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SignatureOverridesFilterValuesResponseInner list(String resourceGroupName, String firewallPolicyName, SignatureOverridesFilterValuesQuery parameters) {
        return this.listWithResponse(resourceGroupName, firewallPolicyName, parameters, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface FirewallPolicyIdpsSignaturesFilterValuesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/listIdpsFilterOptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SignatureOverridesFilterValuesResponseInner>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="firewallPolicyName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") SignatureOverridesFilterValuesQuery var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

