/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.VirtualNetworkPeeringsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VirtualNetworkPeeringInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkPeeringImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Network;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkPeering;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkPeerings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.IndependentChildrenImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class NetworkPeeringsImpl
extends IndependentChildrenImpl<NetworkPeering, NetworkPeeringImpl, VirtualNetworkPeeringInner, VirtualNetworkPeeringsClient, NetworkManager, Network>
implements NetworkPeerings {
    private final NetworkImpl network;

    NetworkPeeringsImpl(NetworkImpl parent) {
        super(((NetworkManagementClient)((NetworkManager)parent.manager()).serviceClient()).getVirtualNetworkPeerings(), (NetworkManager)parent.manager());
        this.network = parent;
    }

    @Override
    public NetworkPeeringImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    protected NetworkPeeringImpl wrapModel(String name) {
        VirtualNetworkPeeringInner inner = new VirtualNetworkPeeringInner().withName(name);
        return new NetworkPeeringImpl(inner, this.network);
    }

    @Override
    protected NetworkPeeringImpl wrapModel(VirtualNetworkPeeringInner inner) {
        return inner != null ? new NetworkPeeringImpl(inner, this.network) : null;
    }

    @Override
    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        return ((NetworkManager)this.manager()).networks().getByResourceGroupAsync(groupName, parentName).flatMap(localNetwork -> {
            if (localNetwork == null) {
                return Mono.empty();
            }
            String peeringId = localNetwork.id() + "/peerings/" + name;
            return localNetwork.peerings().getByIdAsync(peeringId);
        }).flux().flatMap(localPeering -> {
            if (localPeering == null) {
                return Mono.empty();
            }
            if (!localPeering.isSameSubscription()) {
                return Mono.just(localPeering);
            }
            return Mono.just(localPeering).concatWith(localPeering.getRemotePeeringAsync());
        }).flatMap(peering -> {
            if (peering == null) {
                return Mono.empty();
            }
            String networkName = ResourceUtils.nameFromResourceId(peering.networkId());
            return ((NetworkManagementClient)((NetworkManager)peering.manager()).serviceClient()).getVirtualNetworkPeerings().deleteAsync(peering.resourceGroupName(), networkName, peering.name());
        }).then();
    }

    @Override
    public Mono<NetworkPeering> getByParentAsync(String resourceGroup, String parentName, String name) {
        return ((VirtualNetworkPeeringsClient)this.innerModel()).getAsync(resourceGroup, parentName, name).map(inner -> this.wrapModel((VirtualNetworkPeeringInner)inner));
    }

    @Override
    public PagedIterable<NetworkPeering> listByParent(String resourceGroupName, String parentName) {
        return this.wrapList(((VirtualNetworkPeeringsClient)this.innerModel()).list(resourceGroupName, parentName));
    }

    @Override
    public PagedIterable<NetworkPeering> list() {
        return this.wrapList(((VirtualNetworkPeeringsClient)this.innerModel()).list(this.network.resourceGroupName(), this.network.name()));
    }

    @Override
    public PagedFlux<NetworkPeering> listAsync() {
        return this.wrapPageAsync(((VirtualNetworkPeeringsClient)this.innerModel()).listAsync(this.network.resourceGroupName(), this.network.name()));
    }

    @Override
    public NetworkPeering getByRemoteNetwork(Network network) {
        return network != null ? this.getByRemoteNetwork(network.id()) : null;
    }

    @Override
    public NetworkPeering getByRemoteNetwork(String remoteNetworkResourceId) {
        if (remoteNetworkResourceId != null) {
            for (NetworkPeering peering : this.list()) {
                if (!peering.remoteNetworkId().equalsIgnoreCase(remoteNetworkResourceId)) continue;
                return peering;
            }
        }
        return null;
    }

    @Override
    public Mono<NetworkPeering> getByRemoteNetworkAsync(Network network) {
        if (network != null) {
            return this.getByRemoteNetworkAsync(network.id());
        }
        return Mono.empty();
    }

    @Override
    public Mono<NetworkPeering> getByRemoteNetworkAsync(String remoteNetworkResourceId) {
        if (remoteNetworkResourceId == null) {
            return Mono.empty();
        }
        return this.listAsync().filter(peering -> {
            if (peering == null) {
                return false;
            }
            return remoteNetworkResourceId.equalsIgnoreCase(peering.remoteNetworkId());
        }).last();
    }
}

